/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.driver.permission;

import com.google.common.base.Preconditions;
import eu.cloudnetservice.common.hash.HashUtil;
import eu.cloudnetservice.driver.document.Document;
import eu.cloudnetservice.driver.document.property.DefaultedDocPropertyHolder;
import eu.cloudnetservice.driver.permission.AbstractPermissible;
import eu.cloudnetservice.driver.permission.Permission;
import eu.cloudnetservice.driver.permission.PermissionUserGroupInfo;
import java.util.Base64;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.jetbrains.annotations.Nullable;

public class PermissionUser
extends AbstractPermissible {
    private final UUID uniqueId;
    private final String hashedPassword;
    private final Set<PermissionUserGroupInfo> groups;

    protected PermissionUser(@NonNull UUID uniqueId, @Nullable String hashedPassword, @NonNull Set<PermissionUserGroupInfo> groups, @NonNull String name, int potency, long createdTime, @NonNull Set<Permission> permissions, @NonNull Map<String, Set<Permission>> groupPermissions, @NonNull Document properties) {
        super(name, potency, createdTime, permissions, groupPermissions, properties);
        if (uniqueId == null) {
            throw new NullPointerException("uniqueId is marked non-null but is null");
        }
        if (groups == null) {
            throw new NullPointerException("groups is marked non-null but is null");
        }
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (permissions == null) {
            throw new NullPointerException("permissions is marked non-null but is null");
        }
        if (groupPermissions == null) {
            throw new NullPointerException("groupPermissions is marked non-null but is null");
        }
        if (properties == null) {
            throw new NullPointerException("properties is marked non-null but is null");
        }
        this.uniqueId = uniqueId;
        this.hashedPassword = hashedPassword;
        this.groups = groups;
    }

    @NonNull
    public static Builder builder() {
        return new Builder();
    }

    @NonNull
    public static Builder builder(@NonNull PermissionUser user) {
        if (user == null) {
            throw new NullPointerException("user is marked non-null but is null");
        }
        return PermissionUser.builder().name(user.name()).uniqueId(user.uniqueId()).hashedPassword(user.hashedPassword()).potency(user.potency()).properties(user.propertyHolder()).permissions(user.permissions()).groups(user.groups()).groupPermissions(user.groupPermissions());
    }

    public boolean checkPassword(@Nullable String password) {
        return this.hashedPassword != null && password != null && this.hashedPassword.equals(Base64.getEncoder().encodeToString(HashUtil.toSha256((String)password)));
    }

    @NonNull
    public UUID uniqueId() {
        return this.uniqueId;
    }

    @NonNull
    public Collection<PermissionUserGroupInfo> groups() {
        return this.groups;
    }

    @Nullable
    public String hashedPassword() {
        return this.hashedPassword;
    }

    @Override
    @NonNull
    public Collection<String> groupNames() {
        return this.groups().stream().map(PermissionUserGroupInfo::group).collect(Collectors.toList());
    }

    @Nullable
    public PermissionUserGroupInfo findAssignedGroup(@NonNull String group) {
        if (group == null) {
            throw new NullPointerException("group is marked non-null but is null");
        }
        return this.groups.stream().filter(info -> info.group().equalsIgnoreCase(group)).findFirst().orElse(null);
    }

    @NonNull
    public PermissionUser addGroup(@NonNull String group) {
        if (group == null) {
            throw new NullPointerException("group is marked non-null but is null");
        }
        return this.addGroup(group, 0L);
    }

    @NonNull
    public PermissionUser addGroup(@NonNull String group, long timeOutMillis) {
        if (group == null) {
            throw new NullPointerException("group is marked non-null but is null");
        }
        return this.addGroup(PermissionUserGroupInfo.builder().group(group).timeOutMillis(timeOutMillis).build());
    }

    @NonNull
    public PermissionUser addGroup(@NonNull PermissionUserGroupInfo groupInfo) {
        if (groupInfo == null) {
            throw new NullPointerException("groupInfo is marked non-null but is null");
        }
        PermissionUserGroupInfo oldInfo = this.groups().stream().filter(info -> info.group().equalsIgnoreCase(groupInfo.group())).findFirst().orElse(null);
        if (oldInfo != null) {
            this.removeGroup(oldInfo.group());
        }
        this.groups().add(groupInfo);
        return this;
    }

    public boolean removeGroup(@NonNull String group) {
        if (group == null) {
            throw new NullPointerException("group is marked non-null but is null");
        }
        return this.groups.removeIf(info -> info.group().equalsIgnoreCase(group));
    }

    public boolean inGroup(@NonNull String group) {
        if (group == null) {
            throw new NullPointerException("group is marked non-null but is null");
        }
        return this.groups().stream().anyMatch(info -> info.group().equalsIgnoreCase(group));
    }

    @Override
    public String toString() {
        return "PermissionUser(uniqueId=" + this.uniqueId + ", hashedPassword=" + this.hashedPassword + ", groups=" + this.groups + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PermissionUser)) {
            return false;
        }
        PermissionUser other = (PermissionUser)o;
        if (!other.canEqual(this)) {
            return false;
        }
        UUID this$uniqueId = this.uniqueId;
        UUID other$uniqueId = other.uniqueId;
        if (this$uniqueId == null ? other$uniqueId != null : !((Object)this$uniqueId).equals(other$uniqueId)) {
            return false;
        }
        String this$hashedPassword = this.hashedPassword;
        String other$hashedPassword = other.hashedPassword;
        if (this$hashedPassword == null ? other$hashedPassword != null : !this$hashedPassword.equals(other$hashedPassword)) {
            return false;
        }
        Set<PermissionUserGroupInfo> this$groups = this.groups;
        Set<PermissionUserGroupInfo> other$groups = other.groups;
        return !(this$groups == null ? other$groups != null : !((Object)this$groups).equals(other$groups));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof PermissionUser;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        UUID $uniqueId = this.uniqueId;
        result = result * 59 + ($uniqueId == null ? 43 : ((Object)$uniqueId).hashCode());
        String $hashedPassword = this.hashedPassword;
        result = result * 59 + ($hashedPassword == null ? 43 : $hashedPassword.hashCode());
        Set<PermissionUserGroupInfo> $groups = this.groups;
        result = result * 59 + ($groups == null ? 43 : ((Object)$groups).hashCode());
        return result;
    }

    public static final class Builder
    implements DefaultedDocPropertyHolder.Mutable.WithDirectModifier<Builder> {
        private String name;
        private UUID uniqueId;
        private String hashedPassword;
        private int potency;
        private Document.Mutable properties = Document.newJsonDocument();
        private Set<Permission> permissions = new HashSet<Permission>();
        private Set<PermissionUserGroupInfo> groups = new HashSet<PermissionUserGroupInfo>();
        private Map<String, Set<Permission>> groupPermissions = new HashMap<String, Set<Permission>>();

        @NonNull
        public Builder name(@NonNull String name) {
            if (name == null) {
                throw new NullPointerException("name is marked non-null but is null");
            }
            this.name = name;
            return this;
        }

        @NonNull
        public Builder uniqueId(@NonNull UUID uniqueId) {
            if (uniqueId == null) {
                throw new NullPointerException("uniqueId is marked non-null but is null");
            }
            this.uniqueId = uniqueId;
            return this;
        }

        @NonNull
        public Builder password(@NonNull String password) {
            if (password == null) {
                throw new NullPointerException("password is marked non-null but is null");
            }
            this.hashedPassword = Base64.getEncoder().encodeToString(HashUtil.toSha256((String)password));
            return this;
        }

        @NonNull
        public Builder hashedPassword(@Nullable String hashedPassword) {
            this.hashedPassword = hashedPassword;
            return this;
        }

        @NonNull
        public Builder potency(int potency) {
            this.potency = potency;
            return this;
        }

        @NonNull
        public Builder permissions(@NonNull Collection<Permission> permissions) {
            if (permissions == null) {
                throw new NullPointerException("permissions is marked non-null but is null");
            }
            this.permissions = new HashSet<Permission>(permissions);
            return this;
        }

        @NonNull
        public Builder addPermission(@NonNull Permission permission) {
            if (permission == null) {
                throw new NullPointerException("permission is marked non-null but is null");
            }
            this.permissions.add(permission);
            return this;
        }

        @NonNull
        public Builder groups(@NonNull Collection<PermissionUserGroupInfo> groups) {
            if (groups == null) {
                throw new NullPointerException("groups is marked non-null but is null");
            }
            this.groups = new HashSet<PermissionUserGroupInfo>(groups);
            return this;
        }

        @NonNull
        public Builder addGroup(@NonNull PermissionUserGroupInfo group) {
            if (group == null) {
                throw new NullPointerException("group is marked non-null but is null");
            }
            this.groups.add(group);
            return this;
        }

        @NonNull
        public Builder groupPermissions(@NonNull Map<String, Set<Permission>> groupPermissions) {
            if (groupPermissions == null) {
                throw new NullPointerException("groupPermissions is marked non-null but is null");
            }
            this.groupPermissions = new HashMap<String, Set<Permission>>(groupPermissions);
            return this;
        }

        @NonNull
        public Builder properties(@NonNull Document properties) {
            if (properties == null) {
                throw new NullPointerException("properties is marked non-null but is null");
            }
            this.properties = properties.mutableCopy();
            return this;
        }

        @Override
        @NonNull
        public Document.Mutable propertyHolder() {
            return this.properties;
        }

        @NonNull
        public PermissionUser build() {
            Preconditions.checkNotNull((Object)this.name, (Object)"Name must be given");
            Preconditions.checkNotNull((Object)this.uniqueId, (Object)"Unique id must be given");
            return new PermissionUser(this.uniqueId, this.hashedPassword, this.groups, this.name, this.potency, System.currentTimeMillis(), this.permissions, this.groupPermissions, this.properties.immutableCopy());
        }
    }
}

