/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.driver.permission;

import com.google.common.base.Preconditions;
import eu.cloudnetservice.driver.document.Document;
import eu.cloudnetservice.driver.document.property.DefaultedDocPropertyHolder;
import eu.cloudnetservice.driver.permission.AbstractPermissible;
import eu.cloudnetservice.driver.permission.Permission;
import io.leangen.geantyref.TypeFactory;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import lombok.NonNull;

public class PermissionGroup
extends AbstractPermissible {
    public static final Type COL_GROUPS = TypeFactory.parameterizedClass(Collection.class, (Type[])new Type[]{PermissionGroup.class});
    private final String color;
    private final String prefix;
    private final String suffix;
    private final String display;
    private final int sortId;
    private final boolean defaultGroup;
    private final Set<String> groups;

    protected PermissionGroup(@NonNull String color, @NonNull String prefix, @NonNull String suffix, @NonNull String display, int sortId, boolean defaultGroup, @NonNull Set<String> groups, @NonNull String name, int potency, long createdTime, @NonNull Set<Permission> permissions, @NonNull Map<String, Set<Permission>> groupPermissions, @NonNull Document properties) {
        super(name, potency, createdTime, permissions, groupPermissions, properties);
        if (color == null) {
            throw new NullPointerException("color is marked non-null but is null");
        }
        if (prefix == null) {
            throw new NullPointerException("prefix is marked non-null but is null");
        }
        if (suffix == null) {
            throw new NullPointerException("suffix is marked non-null but is null");
        }
        if (display == null) {
            throw new NullPointerException("display is marked non-null but is null");
        }
        if (groups == null) {
            throw new NullPointerException("groups is marked non-null but is null");
        }
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (permissions == null) {
            throw new NullPointerException("permissions is marked non-null but is null");
        }
        if (groupPermissions == null) {
            throw new NullPointerException("groupPermissions is marked non-null but is null");
        }
        if (properties == null) {
            throw new NullPointerException("properties is marked non-null but is null");
        }
        this.color = color;
        this.prefix = prefix;
        this.suffix = suffix;
        this.display = display;
        this.sortId = sortId;
        this.defaultGroup = defaultGroup;
        this.groups = groups;
    }

    @NonNull
    public static Builder builder() {
        return new Builder();
    }

    @NonNull
    public static Builder builder(@NonNull PermissionGroup group) {
        if (group == null) {
            throw new NullPointerException("group is marked non-null but is null");
        }
        return PermissionGroup.builder().name(group.name()).potency(group.potency()).color(group.color()).prefix(group.prefix()).suffix(group.suffix()).display(group.display()).sortId(group.sortId()).defaultGroup(group.defaultGroup()).groups(group.groupNames()).permissions(group.permissions()).properties(group.propertyHolder()).groupPermissions(group.groupPermissions());
    }

    @NonNull
    public String prefix() {
        return this.prefix;
    }

    @NonNull
    public String color() {
        return this.color;
    }

    @NonNull
    public String suffix() {
        return this.suffix;
    }

    @NonNull
    public String display() {
        return this.display;
    }

    public int sortId() {
        return this.sortId;
    }

    public boolean defaultGroup() {
        return this.defaultGroup;
    }

    @Override
    @NonNull
    public Collection<String> groupNames() {
        return this.groups;
    }

    public static final class Builder
    implements DefaultedDocPropertyHolder.Mutable.WithDirectModifier<Builder> {
        private String name;
        private int potency;
        private String color = "&7";
        private String prefix = "&7";
        private String suffix = "&f";
        private String display = "&7";
        private int sortId = 0;
        private boolean defaultGroup = false;
        private Set<String> groups = new HashSet<String>();
        private Set<Permission> permissions = new HashSet<Permission>();
        private Document.Mutable properties = Document.newJsonDocument();
        private Map<String, Set<Permission>> groupPermissions = new HashMap<String, Set<Permission>>();

        @NonNull
        public Builder name(@NonNull String name) {
            if (name == null) {
                throw new NullPointerException("name is marked non-null but is null");
            }
            this.name = name;
            return this;
        }

        @NonNull
        public Builder potency(int potency) {
            this.potency = potency;
            return this;
        }

        @NonNull
        public Builder color(@NonNull String color) {
            if (color == null) {
                throw new NullPointerException("color is marked non-null but is null");
            }
            this.color = color;
            return this;
        }

        @NonNull
        public Builder prefix(@NonNull String prefix) {
            if (prefix == null) {
                throw new NullPointerException("prefix is marked non-null but is null");
            }
            this.prefix = prefix;
            return this;
        }

        @NonNull
        public Builder suffix(@NonNull String suffix) {
            if (suffix == null) {
                throw new NullPointerException("suffix is marked non-null but is null");
            }
            this.suffix = suffix;
            return this;
        }

        @NonNull
        public Builder display(@NonNull String display) {
            if (display == null) {
                throw new NullPointerException("display is marked non-null but is null");
            }
            this.display = display;
            return this;
        }

        @NonNull
        public Builder sortId(int sortId) {
            this.sortId = sortId;
            return this;
        }

        @NonNull
        public Builder defaultGroup(boolean defaultGroup) {
            this.defaultGroup = defaultGroup;
            return this;
        }

        @NonNull
        public Builder addGroup(@NonNull PermissionGroup group) {
            if (group == null) {
                throw new NullPointerException("group is marked non-null but is null");
            }
            this.groups.add(group.name());
            return this;
        }

        @NonNull
        public Builder groups(@NonNull Collection<String> groups) {
            if (groups == null) {
                throw new NullPointerException("groups is marked non-null but is null");
            }
            this.groups = new HashSet<String>(groups);
            return this;
        }

        @NonNull
        public Builder addPermission(@NonNull Permission permission) {
            if (permission == null) {
                throw new NullPointerException("permission is marked non-null but is null");
            }
            this.permissions.add(permission);
            return this;
        }

        @NonNull
        public Builder permissions(@NonNull Collection<Permission> permissions) {
            if (permissions == null) {
                throw new NullPointerException("permissions is marked non-null but is null");
            }
            this.permissions = new HashSet<Permission>(permissions);
            return this;
        }

        @NonNull
        public Builder groupPermissions(@NonNull Map<String, Set<Permission>> groupPermissions) {
            if (groupPermissions == null) {
                throw new NullPointerException("groupPermissions is marked non-null but is null");
            }
            this.groupPermissions = new HashMap<String, Set<Permission>>(groupPermissions);
            return this;
        }

        @NonNull
        public Builder properties(@NonNull Document properties) {
            if (properties == null) {
                throw new NullPointerException("properties is marked non-null but is null");
            }
            this.properties = properties.mutableCopy();
            return this;
        }

        @Override
        @NonNull
        public Document.Mutable propertyHolder() {
            return this.properties;
        }

        @NonNull
        public PermissionGroup build() {
            Preconditions.checkNotNull((Object)this.name, (Object)"No name given");
            return new PermissionGroup(this.color, this.prefix, this.suffix, this.display, this.sortId, this.defaultGroup, this.groups, this.name, this.potency, System.currentTimeMillis(), this.permissions, this.groupPermissions, this.properties.immutableCopy());
        }
    }
}

