/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.driver.permission;

import com.google.common.base.Preconditions;
import eu.cloudnetservice.common.Named;
import java.util.concurrent.TimeUnit;
import lombok.NonNull;

public record Permission(@NonNull String name, int potency, long timeOutMillis) implements Named,
Comparable<Permission>
{
    public Permission(@NonNull String name, int potency, long timeOutMillis) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
    }

    @NonNull
    public static Permission of(@NonNull String permission) {
        if (permission == null) {
            throw new NullPointerException("permission is marked non-null but is null");
        }
        return Permission.builder().name(permission).build();
    }

    @NonNull
    public static Builder builder() {
        return new Builder();
    }

    @NonNull
    public static Builder builder(@NonNull Permission permission) {
        if (permission == null) {
            throw new NullPointerException("permission is marked non-null but is null");
        }
        return Permission.builder().name(permission.name()).potency(permission.potency()).timeOutMillis(permission.timeOutMillis());
    }

    @Override
    public int compareTo(@NonNull Permission other) {
        if (other == null) {
            throw new NullPointerException("other is marked non-null but is null");
        }
        return Integer.compare(Math.abs(this.potency()), Math.abs(other.potency()));
    }

    public static class Builder {
        private String name;
        private int potency = 0;
        private long timeOutMillis = 0L;

        @NonNull
        public Builder name(@NonNull String name) {
            if (name == null) {
                throw new NullPointerException("name is marked non-null but is null");
            }
            this.name = name;
            return this;
        }

        @NonNull
        public Builder potency(int potency) {
            this.potency = potency;
            return this;
        }

        @NonNull
        public Builder timeOutMillis(long timeOutMillis) {
            this.timeOutMillis = timeOutMillis;
            return this;
        }

        @NonNull
        public Builder timeOutMillis(@NonNull TimeUnit unit, long timeOut) {
            if (unit == null) {
                throw new NullPointerException("unit is marked non-null but is null");
            }
            return this.timeOutMillis(System.currentTimeMillis() + unit.toMillis(timeOut));
        }

        @NonNull
        public Permission build() {
            Preconditions.checkNotNull((Object)this.name, (Object)"No name given");
            return new Permission(this.name, this.potency, this.timeOutMillis);
        }
    }
}

