/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.driver.permission;

import eu.cloudnetservice.common.Named;
import eu.cloudnetservice.driver.document.property.DocPropertyHolder;
import eu.cloudnetservice.driver.inject.InjectionLayer;
import eu.cloudnetservice.driver.permission.Permission;
import eu.cloudnetservice.driver.permission.PermissionCheckResult;
import eu.cloudnetservice.driver.permission.PermissionManagement;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import lombok.NonNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public interface Permissible
extends Named,
DocPropertyHolder,
Comparable<Permissible> {
    public int potency();

    public boolean removePermission(@NonNull String var1);

    public boolean removePermission(@NonNull String var1, @NonNull String var2);

    @NonNull
    public Collection<Permission> permissions();

    @NonNull
    public Map<String, Set<Permission>> groupPermissions();

    @NonNull
    public Collection<String> groupNames();

    @Nullable
    default public Permission permission(@Nullable String name) {
        return name == null ? null : (Permission)this.permissions().stream().filter(permission -> permission.name().equalsIgnoreCase(name)).findFirst().orElse(null);
    }

    default public boolean isPermissionSet(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        return this.permissions().stream().anyMatch(permission -> permission.name().equalsIgnoreCase(name));
    }

    public long creationTime();

    public void addPermission(@NonNull Permission var1);

    default public void addPermission(@NonNull String permission) {
        if (permission == null) {
            throw new NullPointerException("permission is marked non-null but is null");
        }
        this.addPermission(Permission.of(permission));
    }

    public void addPermission(@NonNull String var1, @NonNull Permission var2);

    default public void addPermission(@NonNull String group, @NonNull String permission) {
        if (group == null) {
            throw new NullPointerException("group is marked non-null but is null");
        }
        if (permission == null) {
            throw new NullPointerException("permission is marked non-null but is null");
        }
        this.addPermission(group, Permission.of(permission));
    }

    default public @Unmodifiable @NonNull Collection<String> permissionNames() {
        return this.permissions().stream().map(Named::name).toList();
    }

    @NonNull
    default public PermissionCheckResult hasPermission(@NonNull Collection<Permission> permissions, @NonNull Permission permission) {
        if (permissions == null) {
            throw new NullPointerException("permissions is marked non-null but is null");
        }
        if (permission == null) {
            throw new NullPointerException("permission is marked non-null but is null");
        }
        return PermissionCheckResult.fromPermission(this.findMatchingPermission(permissions, permission));
    }

    @Nullable
    default public Permission findMatchingPermission(@NonNull Collection<Permission> permissions, @NonNull Permission permission) {
        if (permissions == null) {
            throw new NullPointerException("permissions is marked non-null but is null");
        }
        if (permission == null) {
            throw new NullPointerException("permission is marked non-null but is null");
        }
        PermissionManagement permissionManagement = InjectionLayer.boot().instance(PermissionManagement.class);
        return permissionManagement.findHighestPermission(permissions, permission);
    }

    @NonNull
    default public PermissionCheckResult hasPermission(@NonNull String group, @NonNull Permission permission) {
        if (group == null) {
            throw new NullPointerException("group is marked non-null but is null");
        }
        if (permission == null) {
            throw new NullPointerException("permission is marked non-null but is null");
        }
        return this.groupPermissions().containsKey(group) ? this.hasPermission((Collection<Permission>)this.groupPermissions().get(group), permission) : PermissionCheckResult.DENIED;
    }

    @NonNull
    default public PermissionCheckResult hasPermission(@NonNull Permission permission) {
        if (permission == null) {
            throw new NullPointerException("permission is marked non-null but is null");
        }
        return this.hasPermission(this.permissions(), permission);
    }

    @NonNull
    default public PermissionCheckResult hasPermission(@NonNull String permission) {
        if (permission == null) {
            throw new NullPointerException("permission is marked non-null but is null");
        }
        return this.hasPermission(Permission.of(permission));
    }

    @Override
    default public int compareTo(@NonNull Permissible o) {
        if (o == null) {
            throw new NullPointerException("o is marked non-null but is null");
        }
        return this.potency() + o.potency();
    }
}

