/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.driver.permission;

import eu.cloudnetservice.driver.document.Document;
import eu.cloudnetservice.driver.document.property.DefaultedDocPropertyHolder;
import eu.cloudnetservice.driver.permission.Permissible;
import eu.cloudnetservice.driver.permission.Permission;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import lombok.NonNull;

public abstract class AbstractPermissible
implements DefaultedDocPropertyHolder,
Permissible {
    protected final String name;
    protected final int potency;
    protected final long createdTime;
    protected final Set<Permission> permissions;
    protected final Map<String, Set<Permission>> groupPermissions;
    protected final Document properties;

    public AbstractPermissible(@NonNull String name, int potency, long createdTime, @NonNull Set<Permission> permissions, @NonNull Map<String, Set<Permission>> groupPermissions, @NonNull Document properties) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (permissions == null) {
            throw new NullPointerException("permissions is marked non-null but is null");
        }
        if (groupPermissions == null) {
            throw new NullPointerException("groupPermissions is marked non-null but is null");
        }
        if (properties == null) {
            throw new NullPointerException("properties is marked non-null but is null");
        }
        this.name = name;
        this.potency = potency;
        this.createdTime = createdTime;
        this.permissions = permissions;
        this.groupPermissions = groupPermissions;
        this.properties = properties;
    }

    private void addPermission(@NonNull Set<Permission> permissions, @NonNull Permission permission) {
        if (permissions == null) {
            throw new NullPointerException("permissions is marked non-null but is null");
        }
        if (permission == null) {
            throw new NullPointerException("permission is marked non-null but is null");
        }
        permissions.removeIf(existingPermission -> existingPermission.name().equalsIgnoreCase(permission.name()));
        permissions.add(permission);
    }

    @Override
    public void addPermission(@NonNull Permission permission) {
        if (permission == null) {
            throw new NullPointerException("permission is marked non-null but is null");
        }
        this.addPermission(this.permissions, permission);
    }

    @Override
    public void addPermission(@NonNull String group, @NonNull Permission permission) {
        if (group == null) {
            throw new NullPointerException("group is marked non-null but is null");
        }
        if (permission == null) {
            throw new NullPointerException("permission is marked non-null but is null");
        }
        this.addPermission(this.groupPermissions.computeIfAbsent(group, s -> new HashSet()), permission);
    }

    @Override
    public boolean removePermission(@NonNull String permission) {
        if (permission == null) {
            throw new NullPointerException("permission is marked non-null but is null");
        }
        Permission exist = this.permission(permission);
        if (exist != null) {
            return this.permissions.remove(exist);
        }
        return false;
    }

    @Override
    public boolean removePermission(@NonNull String permission, @NonNull String group) {
        if (permission == null) {
            throw new NullPointerException("permission is marked non-null but is null");
        }
        if (group == null) {
            throw new NullPointerException("group is marked non-null but is null");
        }
        Set<Permission> permissions = this.groupPermissions.get(group);
        if (permissions != null) {
            boolean removed = permissions.removeIf(perm -> perm.name().equalsIgnoreCase(permission));
            if (removed && permissions.isEmpty()) {
                this.groupPermissions.remove(group);
            }
            return removed;
        }
        return false;
    }

    @Override
    public long creationTime() {
        return this.createdTime;
    }

    @NonNull
    public String name() {
        return this.name;
    }

    @Override
    public int potency() {
        return this.potency;
    }

    @Override
    @NonNull
    public Collection<Permission> permissions() {
        return this.permissions;
    }

    @Override
    @NonNull
    public Map<String, Set<Permission>> groupPermissions() {
        return this.groupPermissions;
    }

    @Override
    @NonNull
    public Document propertyHolder() {
        return this.properties;
    }

    public String toString() {
        return "AbstractPermissible(name=" + this.name + ", potency=" + this.potency + ", createdTime=" + this.createdTime + ", permissions=" + this.permissions + ", groupPermissions=" + this.groupPermissions + ", properties=" + this.properties + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AbstractPermissible)) {
            return false;
        }
        AbstractPermissible other = (AbstractPermissible)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.potency != other.potency) {
            return false;
        }
        if (this.createdTime != other.createdTime) {
            return false;
        }
        String this$name = this.name;
        String other$name = other.name;
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        Set<Permission> this$permissions = this.permissions;
        Set<Permission> other$permissions = other.permissions;
        if (this$permissions == null ? other$permissions != null : !((Object)this$permissions).equals(other$permissions)) {
            return false;
        }
        Map<String, Set<Permission>> this$groupPermissions = this.groupPermissions;
        Map<String, Set<Permission>> other$groupPermissions = other.groupPermissions;
        if (this$groupPermissions == null ? other$groupPermissions != null : !((Object)this$groupPermissions).equals(other$groupPermissions)) {
            return false;
        }
        Document this$properties = this.properties;
        Document other$properties = other.properties;
        return !(this$properties == null ? other$properties != null : !((Object)this$properties).equals(other$properties));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AbstractPermissible;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.potency;
        long $createdTime = this.createdTime;
        result = result * 59 + (int)($createdTime >>> 32 ^ $createdTime);
        String $name = this.name;
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        Set<Permission> $permissions = this.permissions;
        result = result * 59 + ($permissions == null ? 43 : ((Object)$permissions).hashCode());
        Map<String, Set<Permission>> $groupPermissions = this.groupPermissions;
        result = result * 59 + ($groupPermissions == null ? 43 : ((Object)$groupPermissions).hashCode());
        Document $properties = this.properties;
        result = result * 59 + ($properties == null ? 43 : $properties.hashCode());
        return result;
    }
}

