/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.driver.network.rpc.listener;

import eu.cloudnetservice.driver.network.NetworkChannel;
import eu.cloudnetservice.driver.network.buffer.DataBuf;
import eu.cloudnetservice.driver.network.buffer.DataBufFactory;
import eu.cloudnetservice.driver.network.protocol.BasePacket;
import eu.cloudnetservice.driver.network.protocol.Packet;
import eu.cloudnetservice.driver.network.protocol.PacketListener;
import eu.cloudnetservice.driver.network.rpc.RPCHandler;
import eu.cloudnetservice.driver.network.rpc.RPCHandlerRegistry;
import eu.cloudnetservice.driver.network.rpc.RPCInvocationContext;
import eu.cloudnetservice.driver.network.rpc.defaults.handler.util.ExceptionalResultUtil;
import eu.cloudnetservice.driver.network.rpc.object.ObjectMapper;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import lombok.NonNull;
import org.jetbrains.annotations.Nullable;

@Singleton
public class RPCPacketListener
implements PacketListener {
    private final RPCHandlerRegistry rpcHandlerRegistry;

    @Inject
    public RPCPacketListener(@NonNull RPCHandlerRegistry rpcHandlerRegistry) {
        if (rpcHandlerRegistry == null) {
            throw new NullPointerException("rpcHandlerRegistry is marked non-null but is null");
        }
        this.rpcHandlerRegistry = rpcHandlerRegistry;
    }

    @Override
    public void handle(@NonNull NetworkChannel channel, @NonNull Packet packet) throws Exception {
        if (channel == null) {
            throw new NullPointerException("channel is marked non-null but is null");
        }
        if (packet == null) {
            throw new NullPointerException("packet is marked non-null but is null");
        }
        DataBuf result = null;
        DataBuf buf = packet.content();
        if (buf.readBoolean()) {
            int chainSize = buf.readInt();
            RPCHandler.HandlingResult lastResult = null;
            for (int i = 1; i < chainSize; ++i) {
                if (i == 1) {
                    lastResult = this.handleRaw(buf.readString(), this.buildContext(channel, buf, null, false));
                    continue;
                }
                if (lastResult != null) {
                    if (lastResult.wasSuccessful()) {
                        lastResult = this.handleRaw(buf.readString(), this.buildContext(channel, buf, lastResult.invocationResult(), true));
                        continue;
                    }
                    buf.readString();
                    result = this.serializeResult(lastResult, lastResult.invocationHandler().dataBufFactory(), lastResult.invocationHandler().objectMapper(), this.buildContext(channel, buf, null, true));
                    break;
                }
                this.handleRaw(buf.readString(), this.buildContext(channel, buf, null, true));
            }
            if (result == null && lastResult != null) {
                result = this.handle(buf.readString(), this.buildContext(channel, buf, lastResult.invocationResult(), true));
            }
        } else {
            result = this.handle(buf.readString(), this.buildContext(channel, buf, null, false));
        }
        if (result != null && packet.uniqueId() != null) {
            BasePacket response = new BasePacket(-1, result);
            response.uniqueId(packet.uniqueId());
            channel.sendPacket((Packet)response);
        }
    }

    @Nullable
    protected DataBuf handle(@NonNull String clazz, @NonNull RPCInvocationContext context) {
        if (clazz == null) {
            throw new NullPointerException("clazz is marked non-null but is null");
        }
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        RPCHandler handler = this.rpcHandlerRegistry.handler(clazz);
        if (handler != null) {
            RPCHandler.HandlingResult handlingResult = handler.handle(context);
            return this.serializeResult(handlingResult, handler.dataBufFactory(), handler.objectMapper(), context);
        }
        return null;
    }

    @Nullable
    protected DataBuf serializeResult(@NonNull RPCHandler.HandlingResult result, @NonNull DataBufFactory dataBufFactory, @NonNull ObjectMapper objectMapper, @NonNull RPCInvocationContext context) {
        if (result == null) {
            throw new NullPointerException("result is marked non-null but is null");
        }
        if (dataBufFactory == null) {
            throw new NullPointerException("dataBufFactory is marked non-null but is null");
        }
        if (objectMapper == null) {
            throw new NullPointerException("objectMapper is marked non-null but is null");
        }
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        if (context.expectsMethodResult()) {
            if (result.wasSuccessful() && result.targetMethodInformation().voidMethod()) {
                return dataBufFactory.createWithExpectedSize(2).writeBoolean(true).writeBoolean(false);
            }
            if (result.wasSuccessful()) {
                return objectMapper.writeObject(dataBufFactory.createEmpty().writeBoolean(true), result.invocationResult());
            }
            Throwable throwable = (Throwable)result.invocationResult();
            return ExceptionalResultUtil.serializeThrowable(dataBufFactory.createEmpty().writeBoolean(false), throwable);
        }
        return null;
    }

    @Nullable
    protected RPCHandler.HandlingResult handleRaw(@NonNull String clazz, @NonNull RPCInvocationContext context) {
        if (clazz == null) {
            throw new NullPointerException("clazz is marked non-null but is null");
        }
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        RPCHandler handler = this.rpcHandlerRegistry.handler(clazz);
        return handler == null ? null : handler.handle(context);
    }

    @NonNull
    protected RPCInvocationContext buildContext(@NonNull NetworkChannel channel, @NonNull DataBuf content, @Nullable Object on, boolean strictInstanceUsage) {
        if (channel == null) {
            throw new NullPointerException("channel is marked non-null but is null");
        }
        if (content == null) {
            throw new NullPointerException("content is marked non-null but is null");
        }
        return RPCInvocationContext.builder().workingInstance(on).channel(channel).methodName(content.readString()).expectsMethodResult(content.readBoolean()).argumentCount(content.readInt()).argumentInformation(content).normalizePrimitives(Boolean.TRUE).strictInstanceUsage(strictInstanceUsage).build();
    }
}

