/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.driver.network.rpc.generation;

import eu.cloudnetservice.driver.network.NetworkChannel;
import eu.cloudnetservice.driver.network.NetworkComponent;
import eu.cloudnetservice.driver.network.buffer.DataBufFactory;
import eu.cloudnetservice.driver.network.rpc.object.ObjectMapper;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Supplier;
import lombok.NonNull;
import org.jetbrains.annotations.Nullable;

public record GenerationContext(@Nullable NetworkComponent component, @Nullable Supplier<NetworkChannel> channelSupplier, @Nullable ObjectMapper objectMapper, @Nullable DataBufFactory dataBufFactory, @Nullable Class<?> extendingClass, @NonNull Set<Class<?>> interfaces, boolean implementAllMethods) {
    public GenerationContext(@Nullable NetworkComponent component, @Nullable Supplier<NetworkChannel> channelSupplier, @Nullable ObjectMapper objectMapper, @Nullable DataBufFactory dataBufFactory, @Nullable Class<?> extendingClass, @NonNull Set<Class<?>> interfaces, boolean implementAllMethods) {
        if (interfaces == null) {
            throw new NullPointerException("interfaces is marked non-null but is null");
        }
    }

    @NonNull
    public static Builder builder() {
        return new Builder();
    }

    @NonNull
    public static Builder forClass(@NonNull Class<?> clazz) {
        if (clazz == null) {
            throw new NullPointerException("clazz is marked non-null but is null");
        }
        if (clazz.isInterface()) {
            return GenerationContext.builder().addInterfaces(clazz);
        }
        return GenerationContext.builder().extendingClass(clazz);
    }

    public static final class Builder {
        private NetworkComponent component;
        private Supplier<NetworkChannel> channelSupplier;
        private ObjectMapper objectMapper;
        private DataBufFactory dataBufFactory;
        private Class<?> extendingClass;
        private boolean implementAllMethods = false;
        private Set<Class<?>> interfaces = new HashSet();

        @NonNull
        public Builder component(@Nullable NetworkComponent component) {
            this.component = component;
            return this;
        }

        @NonNull
        public Builder channelSupplier(@Nullable Supplier<NetworkChannel> channelSupplier) {
            this.channelSupplier = channelSupplier;
            return this;
        }

        @NonNull
        public Builder objectMapper(@Nullable ObjectMapper objectMapper) {
            this.objectMapper = objectMapper;
            return this;
        }

        @NonNull
        public Builder dataBufFactory(@Nullable DataBufFactory dataBufFactory) {
            this.dataBufFactory = dataBufFactory;
            return this;
        }

        @NonNull
        public Builder extendingClass(@Nullable Class<?> extendingClass) {
            this.extendingClass = extendingClass;
            return this;
        }

        @NonNull
        public Builder implementAllMethods(boolean implementAllMethods) {
            this.implementAllMethods = implementAllMethods;
            return this;
        }

        @NonNull
        public Builder interfaces(@NonNull Set<Class<?>> interfaces) {
            if (interfaces == null) {
                throw new NullPointerException("interfaces is marked non-null but is null");
            }
            this.interfaces = new HashSet(interfaces);
            return this;
        }

        @NonNull
        public Builder addInterfaces(Class<?> ... interfaces) {
            if (interfaces == null) {
                throw new NullPointerException("interfaces is marked non-null but is null");
            }
            this.interfaces.addAll(Arrays.asList(interfaces));
            return this;
        }

        @NonNull
        public GenerationContext build() {
            return new GenerationContext(this.component, this.channelSupplier, this.objectMapper, this.dataBufFactory, this.extendingClass, this.interfaces, this.implementAllMethods);
        }
    }
}

