/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.driver.network.rpc.defaults.sender;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import eu.cloudnetservice.driver.network.NetworkComponent;
import eu.cloudnetservice.driver.network.buffer.DataBufFactory;
import eu.cloudnetservice.driver.network.rpc.RPC;
import eu.cloudnetservice.driver.network.rpc.RPCFactory;
import eu.cloudnetservice.driver.network.rpc.RPCSender;
import eu.cloudnetservice.driver.network.rpc.defaults.DefaultRPCProvider;
import eu.cloudnetservice.driver.network.rpc.defaults.MethodInformation;
import eu.cloudnetservice.driver.network.rpc.defaults.rpc.DefaultRPC;
import eu.cloudnetservice.driver.network.rpc.object.ObjectMapper;
import lombok.NonNull;
import org.jetbrains.annotations.Nullable;

public class DefaultRPCSender
extends DefaultRPCProvider
implements RPCSender {
    protected static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];
    protected final Class<?> targetClass;
    protected final RPCFactory factory;
    protected final NetworkComponent networkComponent;
    protected final Cache<String, MethodInformation> cachedMethodInformation;

    public DefaultRPCSender(@NonNull RPCFactory factory, @Nullable NetworkComponent component, @NonNull Class<?> targetClass, @NonNull ObjectMapper objectMapper, @NonNull DataBufFactory dataBufFactory) {
        super(targetClass, objectMapper, dataBufFactory);
        if (factory == null) {
            throw new NullPointerException("factory is marked non-null but is null");
        }
        if (targetClass == null) {
            throw new NullPointerException("targetClass is marked non-null but is null");
        }
        if (objectMapper == null) {
            throw new NullPointerException("objectMapper is marked non-null but is null");
        }
        if (dataBufFactory == null) {
            throw new NullPointerException("dataBufFactory is marked non-null but is null");
        }
        this.factory = factory;
        this.targetClass = targetClass;
        this.networkComponent = component;
        this.cachedMethodInformation = Caffeine.newBuilder().build();
    }

    @Override
    @NonNull
    public RPCFactory factory() {
        return this.factory;
    }

    @Override
    @NonNull
    public NetworkComponent associatedComponent() {
        if (this.networkComponent == null) {
            throw new UnsupportedOperationException("Sender has no associated component");
        }
        return this.networkComponent;
    }

    @Override
    @NonNull
    public RPC invokeMethod(@NonNull String methodName) {
        if (methodName == null) {
            throw new NullPointerException("methodName is marked non-null but is null");
        }
        return this.invokeMethod(methodName, EMPTY_OBJECT_ARRAY);
    }

    @Override
    @NonNull
    public RPC invokeMethod(@NonNull String methodName, Object ... args) {
        if (methodName == null) {
            throw new NullPointerException("methodName is marked non-null but is null");
        }
        MethodInformation information = (MethodInformation)this.cachedMethodInformation.get((Object)String.format("%s@%d", methodName, args.length), $ -> MethodInformation.find(null, this.targetClass, methodName, null, args.length));
        return new DefaultRPC(this, this.targetClass, methodName, args, this.objectMapper, information.returnType(), this.dataBufFactory);
    }
}

