/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.driver.network.rpc.defaults.object.serializers;

import com.google.common.base.Preconditions;
import eu.cloudnetservice.driver.network.buffer.DataBuf;
import eu.cloudnetservice.driver.network.rpc.object.ObjectMapper;
import eu.cloudnetservice.driver.network.rpc.object.ObjectSerializer;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Optional;
import lombok.NonNull;
import org.jetbrains.annotations.Nullable;

public class OptionalObjectSerializer
implements ObjectSerializer<Optional<?>> {
    @Override
    @Nullable
    public Optional<?> read(@NonNull DataBuf source, @NonNull Type type, @NonNull ObjectMapper caller) {
        if (source == null) {
            throw new NullPointerException("source is marked non-null but is null");
        }
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        if (caller == null) {
            throw new NullPointerException("caller is marked non-null but is null");
        }
        boolean isPresent = source.startTransaction().readBoolean();
        if (isPresent) {
            Preconditions.checkState((boolean)(type instanceof ParameterizedType), (Object)"Optional rpc read called without parameterized type");
            Type argumentType = ((ParameterizedType)type).getActualTypeArguments()[0];
            return Optional.ofNullable(caller.readObject(source.redoTransaction(), argumentType));
        }
        return Optional.empty();
    }

    @Override
    public void write(@NonNull DataBuf.Mutable dataBuf, @NonNull Optional<?> object, @NonNull Type type, @NonNull ObjectMapper caller) {
        if (dataBuf == null) {
            throw new NullPointerException("dataBuf is marked non-null but is null");
        }
        if (object == null) {
            throw new NullPointerException("object is marked non-null but is null");
        }
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        if (caller == null) {
            throw new NullPointerException("caller is marked non-null but is null");
        }
        caller.writeObject(dataBuf, object.orElse(null));
    }
}

