/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.driver.network.rpc.defaults.object.serializers;

import eu.cloudnetservice.driver.network.buffer.DataBuf;
import eu.cloudnetservice.driver.network.rpc.object.ObjectMapper;
import eu.cloudnetservice.driver.network.rpc.object.ObjectSerializer;
import java.lang.reflect.Type;
import java.util.function.BiConsumer;
import java.util.function.Function;
import lombok.NonNull;
import org.jetbrains.annotations.Nullable;

public class FunctionalObjectSerializer<T>
implements ObjectSerializer<T> {
    private final Function<DataBuf, T> reader;
    private final BiConsumer<DataBuf.Mutable, T> writer;

    protected FunctionalObjectSerializer(@NonNull Function<DataBuf, T> reader, @NonNull BiConsumer<DataBuf.Mutable, T> writer) {
        if (reader == null) {
            throw new NullPointerException("reader is marked non-null but is null");
        }
        if (writer == null) {
            throw new NullPointerException("writer is marked non-null but is null");
        }
        this.reader = reader;
        this.writer = writer;
    }

    @NonNull
    public static <T> FunctionalObjectSerializer<T> of(@NonNull Function<DataBuf, T> reader, @NonNull BiConsumer<DataBuf.Mutable, T> writer) {
        if (reader == null) {
            throw new NullPointerException("reader is marked non-null but is null");
        }
        if (writer == null) {
            throw new NullPointerException("writer is marked non-null but is null");
        }
        return new FunctionalObjectSerializer<T>(reader, writer);
    }

    @Override
    @Nullable
    public T read(@NonNull DataBuf source, @NonNull Type type, @NonNull ObjectMapper caller) {
        if (source == null) {
            throw new NullPointerException("source is marked non-null but is null");
        }
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        if (caller == null) {
            throw new NullPointerException("caller is marked non-null but is null");
        }
        return this.reader.apply(source);
    }

    @Override
    public void write(@NonNull DataBuf.Mutable dataBuf, @Nullable T object, @NonNull Type type, @NonNull ObjectMapper caller) {
        if (dataBuf == null) {
            throw new NullPointerException("dataBuf is marked non-null but is null");
        }
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        if (caller == null) {
            throw new NullPointerException("caller is marked non-null but is null");
        }
        this.writer.accept(dataBuf, (DataBuf.Mutable)object);
    }
}

