/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.driver.network.rpc.defaults.object.serializers;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import com.google.common.base.Preconditions;
import eu.cloudnetservice.driver.network.buffer.DataBuf;
import eu.cloudnetservice.driver.network.rpc.object.ObjectMapper;
import eu.cloudnetservice.driver.network.rpc.object.ObjectSerializer;
import java.lang.reflect.Type;
import java.time.Duration;
import lombok.NonNull;
import org.jetbrains.annotations.Nullable;

public class EnumObjectSerializer
implements ObjectSerializer<Enum<?>> {
    private final LoadingCache<Type, Object[]> enumConstantCache = Caffeine.newBuilder().expireAfterAccess(Duration.ofMinutes(30L)).build(type -> ((Class)type).getEnumConstants());

    @Override
    @Nullable
    public Enum<?> read(@NonNull DataBuf source, @NonNull Type type, @NonNull ObjectMapper caller) {
        if (source == null) {
            throw new NullPointerException("source is marked non-null but is null");
        }
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        if (caller == null) {
            throw new NullPointerException("caller is marked non-null but is null");
        }
        Preconditions.checkState((boolean)(type instanceof Class), (Object)"Called enum read method without proving a class as type");
        Object[] enumConstants = (Object[])this.enumConstantCache.get((Object)type);
        int ordinal = source.readInt();
        return ordinal >= enumConstants.length ? null : (Enum)enumConstants[ordinal];
    }

    @Override
    public void write(@NonNull DataBuf.Mutable dataBuf, @NonNull Enum<?> object, @NonNull Type type, @NonNull ObjectMapper caller) {
        if (dataBuf == null) {
            throw new NullPointerException("dataBuf is marked non-null but is null");
        }
        if (object == null) {
            throw new NullPointerException("object is marked non-null but is null");
        }
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        if (caller == null) {
            throw new NullPointerException("caller is marked non-null but is null");
        }
        dataBuf.writeInt(object.ordinal());
    }
}

