/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.driver.network.rpc.defaults.object.serializers;

import com.google.common.base.Preconditions;
import eu.cloudnetservice.driver.network.buffer.DataBuf;
import eu.cloudnetservice.driver.network.rpc.object.ObjectMapper;
import eu.cloudnetservice.driver.network.rpc.object.ObjectSerializer;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.function.Supplier;
import lombok.NonNull;
import org.jetbrains.annotations.Nullable;

public class CollectionObjectSerializer
implements ObjectSerializer<Collection<?>> {
    private final Supplier<Collection<?>> collectionFactory;

    protected CollectionObjectSerializer(@NonNull Supplier<Collection<?>> collectionFactory) {
        if (collectionFactory == null) {
            throw new NullPointerException("collectionFactory is marked non-null but is null");
        }
        this.collectionFactory = collectionFactory;
    }

    @NonNull
    public static CollectionObjectSerializer of(@NonNull Supplier<Collection<?>> collectionFactory) {
        if (collectionFactory == null) {
            throw new NullPointerException("collectionFactory is marked non-null but is null");
        }
        return new CollectionObjectSerializer(collectionFactory);
    }

    @Override
    @Nullable
    public Collection<?> read(@NonNull DataBuf source, @NonNull Type type, @NonNull ObjectMapper caller) {
        if (source == null) {
            throw new NullPointerException("source is marked non-null but is null");
        }
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        if (caller == null) {
            throw new NullPointerException("caller is marked non-null but is null");
        }
        Collection<?> collection = this.collectionFactory.get();
        int collectionSize = source.readInt();
        if (collectionSize == 0) {
            return collection;
        }
        Preconditions.checkState((boolean)(type instanceof ParameterizedType), (Object)"Collection rpc read called without parameterized type");
        Type parameterType = ((ParameterizedType)type).getActualTypeArguments()[0];
        for (int i = 0; i < collectionSize; ++i) {
            collection.add(caller.readObject(source, parameterType));
        }
        return collection;
    }

    @Override
    public void write(@NonNull DataBuf.Mutable dataBuf, @Nullable Collection<?> object, @NonNull Type type, @NonNull ObjectMapper caller) {
        if (dataBuf == null) {
            throw new NullPointerException("dataBuf is marked non-null but is null");
        }
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        if (caller == null) {
            throw new NullPointerException("caller is marked non-null but is null");
        }
        dataBuf.writeInt(object == null ? 0 : object.size());
        if (object != null) {
            for (Object o : object) {
                caller.writeObject(dataBuf, o);
            }
        }
    }
}

