/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.driver.network.rpc.defaults.object.data;

import eu.cloudnetservice.common.util.StringUtil;
import eu.cloudnetservice.driver.network.buffer.DataBuf;
import eu.cloudnetservice.driver.network.rpc.annotation.RPCFieldGetter;
import eu.cloudnetservice.driver.network.rpc.annotation.RPCIgnore;
import eu.cloudnetservice.driver.network.rpc.exception.ClassCreationException;
import eu.cloudnetservice.driver.network.rpc.object.ObjectMapper;
import eu.cloudnetservice.driver.util.asm.AsmHelper;
import eu.cloudnetservice.driver.util.define.ClassDefiners;
import io.leangen.geantyref.GenericTypeReflector;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.MethodVisitor;

public final class DataClassInvokerGenerator {
    private static final String SUPER = "java/lang/Object";
    private static final String TYPES_DESC = org.objectweb.asm.Type.getDescriptor(Type[].class);
    private static final String[] INSTANCE_CREATOR = new String[]{org.objectweb.asm.Type.getInternalName(DataClassInstanceCreator.class)};
    private static final String MAKE_INSTANCE_DESCRIPTOR = org.objectweb.asm.Type.getMethodDescriptor((org.objectweb.asm.Type)org.objectweb.asm.Type.getType(Object.class), (org.objectweb.asm.Type[])new org.objectweb.asm.Type[]{org.objectweb.asm.Type.getType(DataBuf.class), org.objectweb.asm.Type.getType(ObjectMapper.class)});
    private static final String[] INFO_WRITER = new String[]{org.objectweb.asm.Type.getInternalName(DataClassInformationWriter.class)};
    private static final String WRITE_INFORMATION_DESCRIPTOR = org.objectweb.asm.Type.getMethodDescriptor((org.objectweb.asm.Type)org.objectweb.asm.Type.VOID_TYPE, (org.objectweb.asm.Type[])new org.objectweb.asm.Type[]{org.objectweb.asm.Type.getType(DataBuf.Mutable.class), org.objectweb.asm.Type.getType(Object.class), org.objectweb.asm.Type.getType(ObjectMapper.class)});
    private static final String DATA_BUF_NAME = org.objectweb.asm.Type.getInternalName(ObjectMapper.class);
    private static final String READ_OBJECT_DESC = org.objectweb.asm.Type.getMethodDescriptor((org.objectweb.asm.Type)org.objectweb.asm.Type.getType(Object.class), (org.objectweb.asm.Type[])new org.objectweb.asm.Type[]{org.objectweb.asm.Type.getType(DataBuf.class), org.objectweb.asm.Type.getType(Type.class)});
    private static final String WRITE_OBJECT_DESC = org.objectweb.asm.Type.getMethodDescriptor((org.objectweb.asm.Type)org.objectweb.asm.Type.getType(DataBuf.Mutable.class), (org.objectweb.asm.Type[])new org.objectweb.asm.Type[]{org.objectweb.asm.Type.getType(DataBuf.Mutable.class), org.objectweb.asm.Type.getType(Object.class)});
    private static final String INSTANCE_CREATOR_NAME_FORMAT = "%s$InstanceCreator";
    private static final String INFORMATION_WRITE_NAME_FORMAT = "%s$InformationWriter";

    private DataClassInvokerGenerator() {
        throw new UnsupportedOperationException();
    }

    @NonNull
    public static DataClassInstanceCreator createInstanceCreator(@NonNull Class<?> clazz, @NonNull Type[] types) {
        if (clazz == null) {
            throw new NullPointerException("clazz is marked non-null but is null");
        }
        if (types == null) {
            throw new NullPointerException("types is marked non-null but is null");
        }
        try {
            String className = String.format(INSTANCE_CREATOR_NAME_FORMAT, org.objectweb.asm.Type.getInternalName(clazz));
            ClassWriter cw = new ClassWriter(3);
            cw.visit(52, 17, className, null, SUPER, INSTANCE_CREATOR);
            cw.visitField(18, "types", TYPES_DESC, null, null).visitEnd();
            MethodVisitor mv = cw.visitMethod(1, "<init>", "(" + TYPES_DESC + ")V", null, null);
            mv.visitCode();
            mv.visitVarInsn(25, 0);
            mv.visitMethodInsn(183, SUPER, "<init>", "()V", false);
            mv.visitVarInsn(25, 0);
            mv.visitVarInsn(25, 1);
            mv.visitFieldInsn(181, className, "types", TYPES_DESC);
            mv.visitInsn(177);
            mv.visitMaxs(0, 0);
            mv.visitEnd();
            mv = cw.visitMethod(17, "makeInstance", MAKE_INSTANCE_DESCRIPTOR, null, null);
            mv.visitCode();
            mv.visitTypeInsn(187, org.objectweb.asm.Type.getInternalName(clazz));
            mv.visitInsn(89);
            org.objectweb.asm.Type[] parameters = new org.objectweb.asm.Type[types.length];
            for (int i = 0; i < types.length; ++i) {
                Class rawType = GenericTypeReflector.erase((Type)types[i]);
                mv.visitVarInsn(25, 2);
                mv.visitVarInsn(25, 1);
                mv.visitVarInsn(25, 0);
                mv.visitFieldInsn(180, className, "types", TYPES_DESC);
                AsmHelper.pushInt(mv, i);
                mv.visitInsn(50);
                mv.visitMethodInsn(185, DATA_BUF_NAME, "readObject", READ_OBJECT_DESC, true);
                if (rawType.isPrimitive()) {
                    AsmHelper.wrapperToPrimitive(mv, rawType);
                } else {
                    mv.visitTypeInsn(192, org.objectweb.asm.Type.getInternalName((Class)rawType));
                }
                parameters[i] = org.objectweb.asm.Type.getType((Class)rawType);
            }
            mv.visitMethodInsn(183, org.objectweb.asm.Type.getInternalName(clazz), "<init>", org.objectweb.asm.Type.getMethodDescriptor((org.objectweb.asm.Type)org.objectweb.asm.Type.VOID_TYPE, (org.objectweb.asm.Type[])parameters), false);
            mv.visitInsn(176);
            mv.visitMaxs(0, 0);
            mv.visitEnd();
            cw.visitEnd();
            Constructor<?> constructor = ClassDefiners.current().defineClass(className, clazz, cw.toByteArray()).getDeclaredConstructor(Type[].class);
            constructor.setAccessible(true);
            return (DataClassInstanceCreator)constructor.newInstance(new Object[]{types});
        }
        catch (Exception exception) {
            throw new ClassCreationException(String.format("Unable to generate DataClassInstanceCreator for class %s", clazz.getName()), exception);
        }
    }

    @NonNull
    public static DataClassInformationWriter createWriter(@NonNull Class<?> clazz, @NonNull Collection<Field> fields) {
        if (clazz == null) {
            throw new NullPointerException("clazz is marked non-null but is null");
        }
        if (fields == null) {
            throw new NullPointerException("fields is marked non-null but is null");
        }
        try {
            String className = String.format(INFORMATION_WRITE_NAME_FORMAT, org.objectweb.asm.Type.getInternalName(clazz));
            ClassWriter cw = new ClassWriter(3);
            cw.visit(52, 17, className, null, SUPER, INFO_WRITER);
            MethodVisitor mv = cw.visitMethod(1, "<init>", "()V", null, null);
            mv.visitCode();
            mv.visitVarInsn(25, 0);
            mv.visitMethodInsn(183, SUPER, "<init>", "()V", false);
            mv.visitInsn(177);
            mv.visitMaxs(0, 0);
            mv.visitEnd();
            mv = cw.visitMethod(1, "writeInformation", WRITE_INFORMATION_DESCRIPTOR, null, null);
            mv.visitCode();
            if (fields.size() > 0) {
                HashSet<Method> includedMethods = new HashSet<Method>();
                Class<?> processing = clazz;
                do {
                    for (Method method : processing.getDeclaredMethods()) {
                        if (method.getParameterCount() != 0 || method.isAnnotationPresent(RPCIgnore.class) || !Modifier.isPublic(method.getModifiers()) || Modifier.isStatic(method.getModifiers())) continue;
                        includedMethods.add(method);
                    }
                } while ((processing = processing.getSuperclass()) != Object.class);
                HashMap<Field, Method> fieldGetters = new HashMap<Field, Method>();
                for (Field field : fields) {
                    RPCFieldGetter overriddenGetter = field.getAnnotation(RPCFieldGetter.class);
                    if (overriddenGetter != null) {
                        fieldGetters.put(field, DataClassInvokerGenerator.findGetterForField(includedMethods, field, m -> m.getName().equals(overriddenGetter.value())));
                        continue;
                    }
                    fieldGetters.put(field, DataClassInvokerGenerator.findGetterForField(includedMethods, field, m -> StringUtil.endsWithIgnoreCase((String)m.getName(), (String)field.getName())));
                }
                for (Field field : fields) {
                    Class rawType;
                    mv.visitVarInsn(25, 3);
                    mv.visitVarInsn(25, 1);
                    mv.visitVarInsn(25, 2);
                    Method getter = (Method)fieldGetters.get(field);
                    if (getter != null) {
                        rawType = GenericTypeReflector.erase((Type)getter.getGenericReturnType());
                        declaring = org.objectweb.asm.Type.getInternalName(getter.getDeclaringClass());
                        mv.visitTypeInsn(192, declaring);
                        mv.visitMethodInsn(182, declaring, getter.getName(), org.objectweb.asm.Type.getMethodDescriptor((Method)getter), getter.getDeclaringClass().isInterface());
                    } else {
                        rawType = GenericTypeReflector.erase((Type)field.getGenericType());
                        declaring = org.objectweb.asm.Type.getInternalName(field.getDeclaringClass());
                        mv.visitTypeInsn(192, declaring);
                        mv.visitFieldInsn(180, declaring, field.getName(), org.objectweb.asm.Type.getDescriptor(field.getType()));
                    }
                    if (rawType.isPrimitive()) {
                        AsmHelper.primitiveToWrapper(mv, rawType);
                    }
                    mv.visitMethodInsn(185, DATA_BUF_NAME, "writeObject", WRITE_OBJECT_DESC, true);
                }
            }
            mv.visitInsn(177);
            mv.visitMaxs(0, 0);
            mv.visitEnd();
            cw.visitEnd();
            Constructor<?> constructor = ClassDefiners.current().defineClass(className, clazz, cw.toByteArray()).getDeclaredConstructor(new Class[0]);
            constructor.setAccessible(true);
            return (DataClassInformationWriter)constructor.newInstance(new Object[0]);
        }
        catch (Exception exception) {
            throw new ClassCreationException(String.format("Unable to generate DataClassInformationWriter for class %s and fields %s", clazz.getName(), fields.stream().map(Field::getName).collect(Collectors.joining(", "))), exception);
        }
    }

    @Nullable
    private static Method findGetterForField(@NonNull Collection<Method> methods, @NonNull Field field, @NonNull Predicate<Method> extraFilter) {
        if (methods == null) {
            throw new NullPointerException("methods is marked non-null but is null");
        }
        if (field == null) {
            throw new NullPointerException("field is marked non-null but is null");
        }
        if (extraFilter == null) {
            throw new NullPointerException("extraFilter is marked non-null but is null");
        }
        Method choice = null;
        Predicate<Method> fullFilter = DataClassInvokerGenerator.commonFilter(field).and(extraFilter);
        for (Method method : methods) {
            if (!method.getDeclaringClass().equals(field.getDeclaringClass()) || !fullFilter.test(method)) continue;
            if (choice == null) {
                choice = method;
                continue;
            }
            if (choice.getName().length() <= method.getName().length()) continue;
            choice = method;
        }
        return choice;
    }

    @NonNull
    private static Predicate<Method> commonFilter(@NonNull Field field) {
        if (field == null) {
            throw new NullPointerException("field is marked non-null but is null");
        }
        return method -> method.getReturnType().equals(field.getType());
    }

    @FunctionalInterface
    public static interface DataClassInstanceCreator {
        @NonNull
        public Object makeInstance(@NonNull DataBuf var1, @NonNull ObjectMapper var2);
    }

    @FunctionalInterface
    public static interface DataClassInformationWriter {
        public void writeInformation(@NonNull DataBuf.Mutable var1, @NonNull Object var2, @NonNull ObjectMapper var3);
    }
}

