/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.driver.network.rpc.defaults.object.data;

import eu.cloudnetservice.driver.network.rpc.annotation.RPCIgnore;
import eu.cloudnetservice.driver.network.rpc.defaults.object.data.DataClassInvokerGenerator;
import eu.cloudnetservice.driver.network.rpc.exception.MissingAllArgsConstructorException;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import lombok.NonNull;

public class DataClassInformation {
    private final DataClassInvokerGenerator.DataClassInstanceCreator instanceCreator;
    private final DataClassInvokerGenerator.DataClassInformationWriter informationWriter;

    protected DataClassInformation(@NonNull DataClassInvokerGenerator.DataClassInstanceCreator creator, @NonNull DataClassInvokerGenerator.DataClassInformationWriter writer) {
        if (creator == null) {
            throw new NullPointerException("creator is marked non-null but is null");
        }
        if (writer == null) {
            throw new NullPointerException("writer is marked non-null but is null");
        }
        this.instanceCreator = creator;
        this.informationWriter = writer;
    }

    @NonNull
    public static DataClassInformation createClassInformation(@NonNull Class<?> clazz) {
        if (clazz == null) {
            throw new NullPointerException("clazz is marked non-null but is null");
        }
        List<Field> includedFields = DataClassInformation.collectFields(clazz);
        Type[] types = DataClassInformation.transformToArray(Type.class, includedFields, Field::getGenericType);
        Class[] arguments = DataClassInformation.transformToArray(Class.class, includedFields, Field::getType);
        try {
            clazz.getDeclaredConstructor(arguments);
        }
        catch (NoSuchMethodException exception) {
            throw new MissingAllArgsConstructorException(clazz, arguments);
        }
        DataClassInvokerGenerator.DataClassInstanceCreator instanceCreator = DataClassInvokerGenerator.createInstanceCreator(clazz, types);
        DataClassInvokerGenerator.DataClassInformationWriter informationWriter = DataClassInvokerGenerator.createWriter(clazz, includedFields);
        return new DataClassInformation(instanceCreator, informationWriter);
    }

    @NonNull
    protected static List<Field> collectFields(@NonNull Class<?> clazz) {
        if (clazz == null) {
            throw new NullPointerException("clazz is marked non-null but is null");
        }
        ArrayList<Field> result = new ArrayList<Field>();
        Class<?> processing = clazz;
        do {
            for (Field field : processing.getDeclaredFields()) {
                if (Modifier.isTransient(field.getModifiers()) || Modifier.isStatic(field.getModifiers()) || field.isAnnotationPresent(RPCIgnore.class)) continue;
                result.add(field);
            }
        } while ((processing = processing.getSuperclass()) != Object.class);
        return result;
    }

    @NonNull
    protected static <T, O> O[] transformToArray(@NonNull Class<O> outType, @NonNull List<T> in, @NonNull Function<T, O> transformer) {
        if (outType == null) {
            throw new NullPointerException("outType is marked non-null but is null");
        }
        if (in == null) {
            throw new NullPointerException("in is marked non-null but is null");
        }
        if (transformer == null) {
            throw new NullPointerException("transformer is marked non-null but is null");
        }
        Object[] resultArray = (Object[])Array.newInstance(outType, in.size());
        for (int i = 0; i < in.size(); ++i) {
            resultArray[i] = transformer.apply(in.get(i));
        }
        return resultArray;
    }

    @NonNull
    public DataClassInvokerGenerator.DataClassInstanceCreator instanceCreator() {
        return this.instanceCreator;
    }

    @NonNull
    public DataClassInvokerGenerator.DataClassInformationWriter informationWriter() {
        return this.informationWriter;
    }
}

