/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.driver.network.rpc.defaults.handler.util;

import eu.cloudnetservice.driver.network.buffer.DataBuf;
import eu.cloudnetservice.driver.network.rpc.exception.RPCExecutionException;
import lombok.NonNull;

public final class ExceptionalResultUtil {
    private ExceptionalResultUtil() {
        throw new UnsupportedOperationException();
    }

    @NonNull
    public static DataBuf serializeThrowable(@NonNull DataBuf.Mutable target, @NonNull Throwable throwable) {
        if (target == null) {
            throw new NullPointerException("target is marked non-null but is null");
        }
        if (throwable == null) {
            throw new NullPointerException("throwable is marked non-null but is null");
        }
        target.writeString(throwable.getClass().getSimpleName()).writeNullable(throwable.getMessage(), DataBuf.Mutable::writeString);
        return ExceptionalResultUtil.serializeFirstElement(target, throwable.getStackTrace());
    }

    public static void rethrowException(@NonNull DataBuf source) {
        if (source == null) {
            throw new NullPointerException("source is marked non-null but is null");
        }
        String exceptionClassName = source.readString();
        String exceptionMessage = source.readNullable(DataBuf::readString, "<no message provided>");
        String formattedElement = source.readNullable(dataBuf -> {
            StackTraceElement element = new StackTraceElement(source.readString(), source.readString(), source.readNullable(DataBuf::readString), source.readInt());
            return element.toString();
        }, "<no stack trace available>");
        throw new RPCExecutionException(exceptionClassName, exceptionMessage, formattedElement);
    }

    @NonNull
    private static DataBuf serializeFirstElement(@NonNull DataBuf.Mutable target, StackTraceElement @NonNull [] elements) {
        if (target == null) {
            throw new NullPointerException("target is marked non-null but is null");
        }
        if (elements == null) {
            throw new NullPointerException("elements is marked non-null but is null");
        }
        if (elements.length == 0) {
            return target.writeBoolean(false);
        }
        StackTraceElement element = elements[0];
        return target.writeBoolean(true).writeString(element.getClassName()).writeString(element.getMethodName()).writeNullable(element.getFileName(), DataBuf.Mutable::writeString).writeInt(element.getLineNumber());
    }
}

