/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.driver.network.rpc.defaults.handler.context;

import com.google.common.base.Preconditions;
import eu.cloudnetservice.driver.network.NetworkChannel;
import eu.cloudnetservice.driver.network.buffer.DataBuf;
import eu.cloudnetservice.driver.network.rpc.RPCInvocationContext;
import eu.cloudnetservice.driver.network.rpc.defaults.handler.context.DefaultRPCInvocationContext;
import lombok.NonNull;
import org.jetbrains.annotations.Nullable;

public class DefaultRPCInvocationContextBuilder
implements RPCInvocationContext.Builder {
    protected int argumentCount = 0;
    protected boolean expectsMethodResult = true;
    protected boolean normalizePrimitives = true;
    protected boolean strictInstanceUsage = false;
    protected String methodName;
    protected NetworkChannel channel;
    protected DataBuf arguments;
    protected Object workingInstance;

    @Override
    @NonNull
    public RPCInvocationContext.Builder argumentCount(int argumentCount) {
        this.argumentCount = argumentCount;
        return this;
    }

    @Override
    @NonNull
    public RPCInvocationContext.Builder expectsMethodResult(boolean expectsResult) {
        this.expectsMethodResult = expectsResult;
        return this;
    }

    @Override
    @NonNull
    public RPCInvocationContext.Builder normalizePrimitives(boolean normalizePrimitives) {
        this.normalizePrimitives = normalizePrimitives;
        return this;
    }

    @Override
    @NonNull
    public RPCInvocationContext.Builder strictInstanceUsage(boolean strictInstanceUsage) {
        this.strictInstanceUsage = strictInstanceUsage;
        return this;
    }

    @Override
    @NonNull
    public RPCInvocationContext.Builder methodName(@NonNull String methodName) {
        if (methodName == null) {
            throw new NullPointerException("methodName is marked non-null but is null");
        }
        this.methodName = methodName;
        return this;
    }

    @Override
    @NonNull
    public RPCInvocationContext.Builder channel(@NonNull NetworkChannel channel) {
        if (channel == null) {
            throw new NullPointerException("channel is marked non-null but is null");
        }
        this.channel = channel;
        return this;
    }

    @Override
    @NonNull
    public RPCInvocationContext.Builder argumentInformation(@NonNull DataBuf information) {
        if (information == null) {
            throw new NullPointerException("information is marked non-null but is null");
        }
        this.arguments = information;
        return this;
    }

    @Override
    @NonNull
    public RPCInvocationContext.Builder workingInstance(@Nullable Object instance) {
        this.workingInstance = instance;
        return this;
    }

    @Override
    @NonNull
    public RPCInvocationContext build() {
        Preconditions.checkNotNull((Object)this.arguments, (Object)"No arguments supplied");
        Preconditions.checkNotNull((Object)this.channel, (Object)"No source channel supplied");
        Preconditions.checkNotNull((Object)this.methodName, (Object)"No method name supplied");
        return new DefaultRPCInvocationContext(this.argumentCount, this.expectsMethodResult, this.normalizePrimitives, this.strictInstanceUsage, this.methodName, this.channel, this.arguments, this.workingInstance);
    }
}

