/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.driver.network.rpc.defaults.handler;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.google.common.base.Defaults;
import eu.cloudnetservice.driver.network.buffer.DataBufFactory;
import eu.cloudnetservice.driver.network.rpc.RPCHandler;
import eu.cloudnetservice.driver.network.rpc.RPCHandlerRegistry;
import eu.cloudnetservice.driver.network.rpc.RPCInvocationContext;
import eu.cloudnetservice.driver.network.rpc.defaults.DefaultRPCProvider;
import eu.cloudnetservice.driver.network.rpc.defaults.MethodInformation;
import eu.cloudnetservice.driver.network.rpc.defaults.handler.DefaultHandlingResult;
import eu.cloudnetservice.driver.network.rpc.defaults.handler.invoker.MethodInvokerGenerator;
import eu.cloudnetservice.driver.network.rpc.object.ObjectMapper;
import lombok.NonNull;
import org.jetbrains.annotations.Nullable;

public class DefaultRPCHandler
extends DefaultRPCProvider
implements RPCHandler {
    protected final Class<?> bindingClass;
    protected final Object bindingInstance;
    protected final MethodInvokerGenerator generator;
    protected final Cache<String, MethodInformation> methodCache = Caffeine.newBuilder().build();

    public DefaultRPCHandler(@NonNull Class<?> clazz, @Nullable Object binding, @NonNull ObjectMapper objectMapper, @NonNull DataBufFactory dataBufFactory) {
        super(clazz, objectMapper, dataBufFactory);
        if (clazz == null) {
            throw new NullPointerException("clazz is marked non-null but is null");
        }
        if (objectMapper == null) {
            throw new NullPointerException("objectMapper is marked non-null but is null");
        }
        if (dataBufFactory == null) {
            throw new NullPointerException("dataBufFactory is marked non-null but is null");
        }
        this.bindingClass = clazz;
        this.bindingInstance = binding;
        this.generator = new MethodInvokerGenerator();
    }

    @Override
    public void registerTo(@NonNull RPCHandlerRegistry registry) {
        if (registry == null) {
            throw new NullPointerException("registry is marked non-null but is null");
        }
        registry.registerHandler(this);
    }

    @Override
    @NonNull
    public RPCHandler.HandlingResult handle(@NonNull RPCInvocationContext context) {
        RPCHandler.HandlingResult result;
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        Object inst = context.workingInstance();
        if (inst == null) {
            inst = context.strictInstanceUsage() ? null : this.bindingInstance;
        }
        Object instance = inst;
        MethodInformation information = (MethodInformation)this.methodCache.get((Object)String.format("%d@%s@%s@%d", inst == null ? -1 : inst.hashCode(), this.bindingClass.getCanonicalName(), context.methodName(), context.argumentCount()), $ -> MethodInformation.find(instance, this.bindingClass, context.methodName(), instance == null ? null : this.generator, context.argumentCount()));
        Object[] arguments = new Object[information.arguments().length];
        for (int i = 0; i < arguments.length; ++i) {
            arguments[i] = this.objectMapper.readObject(context.argumentInformation(), information.arguments()[i]);
        }
        if (instance == null) {
            result = information.rawReturnType().isPrimitive() && context.normalizePrimitives() ? DefaultHandlingResult.success(information, this, Defaults.defaultValue(information.rawReturnType())) : DefaultHandlingResult.success(information, this, null);
        } else {
            try {
                Object methodResult = information.methodInvoker().callMethod(arguments);
                result = DefaultHandlingResult.success(information, this, methodResult);
            }
            catch (Throwable throwable) {
                result = DefaultHandlingResult.failure(information, this, throwable);
            }
        }
        return result;
    }
}

