/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.driver.network.rpc.defaults;

import eu.cloudnetservice.driver.network.rpc.annotation.RPCIgnore;
import eu.cloudnetservice.driver.network.rpc.defaults.handler.invoker.MethodInvoker;
import eu.cloudnetservice.driver.network.rpc.defaults.handler.invoker.MethodInvokerGenerator;
import eu.cloudnetservice.driver.network.rpc.exception.CannotDecideException;
import io.leangen.geantyref.GenericTypeReflector;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import lombok.NonNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.UnknownNullability;

public class MethodInformation {
    private final String name;
    private final Type returnType;
    private final Type[] arguments;
    private final boolean voidMethod;
    private final Object sourceInstance;
    private final Class<?> rawReturnType;
    private final Class<?> definingClass;
    private final MethodInvoker methodInvoker;

    protected MethodInformation(@NonNull String name, @NonNull Type rType, @NonNull Type[] arguments, @Nullable Object sourceInstance, @NonNull Class<?> definingClass, @Nullable MethodInvokerGenerator generator) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (rType == null) {
            throw new NullPointerException("rType is marked non-null but is null");
        }
        if (arguments == null) {
            throw new NullPointerException("arguments is marked non-null but is null");
        }
        if (definingClass == null) {
            throw new NullPointerException("definingClass is marked non-null but is null");
        }
        this.name = name;
        this.returnType = rType;
        this.arguments = arguments;
        this.voidMethod = rType.equals(Void.TYPE);
        this.sourceInstance = sourceInstance;
        this.rawReturnType = GenericTypeReflector.erase((Type)rType);
        this.definingClass = definingClass;
        this.methodInvoker = generator == null ? null : generator.makeMethodInvoker(this);
    }

    @NonNull
    public static MethodInformation find(@Nullable Object instance, @NonNull Class<?> sourceClass, @NonNull String name, @Nullable MethodInvokerGenerator generator, int argumentCount) {
        if (sourceClass == null) {
            throw new NullPointerException("sourceClass is marked non-null but is null");
        }
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        Method method = null;
        for (Method declaredMethod : sourceClass.getDeclaredMethods()) {
            if (!declaredMethod.getName().equals(name) || declaredMethod.isAnnotationPresent(RPCIgnore.class) || declaredMethod.getParameterCount() != argumentCount) continue;
            if (method != null) {
                throw new CannotDecideException(name);
            }
            method = declaredMethod;
        }
        if (method == null) {
            throw new CannotDecideException(name);
        }
        return new MethodInformation(name, method.getGenericReturnType(), method.getGenericParameterTypes(), instance, method.getDeclaringClass(), generator);
    }

    @NonNull
    public String name() {
        return this.name;
    }

    @NonNull
    public Type returnType() {
        return this.returnType;
    }

    @NonNull
    public Class<?> rawReturnType() {
        return this.rawReturnType;
    }

    public Type @NonNull [] arguments() {
        return this.arguments;
    }

    public boolean voidMethod() {
        return this.voidMethod;
    }

    public @UnknownNullability Object sourceInstance() {
        return this.sourceInstance;
    }

    @NonNull
    public Class<?> definingClass() {
        return this.definingClass;
    }

    public @UnknownNullability MethodInvoker methodInvoker() {
        return this.methodInvoker;
    }
}

