/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.driver.network.protocol;

import eu.cloudnetservice.driver.network.buffer.DataBuf;
import eu.cloudnetservice.driver.network.protocol.Packet;
import java.time.Instant;
import java.util.UUID;
import lombok.NonNull;
import org.jetbrains.annotations.Nullable;

final class EmptyPacket
implements Packet {
    public static final EmptyPacket INSTANCE = new EmptyPacket();

    private EmptyPacket() {
    }

    @Override
    @NonNull
    public Packet constructResponse(@NonNull DataBuf content) {
        if (content == null) {
            throw new NullPointerException("content is marked non-null but is null");
        }
        throw new UnsupportedOperationException("Unable to construct response for empty packet");
    }

    @Override
    @Nullable
    public UUID uniqueId() {
        return null;
    }

    @Override
    public void uniqueId(@Nullable UUID uniqueId) {
    }

    @Override
    public int channel() {
        return -1;
    }

    @Override
    public boolean prioritized() {
        return false;
    }

    @Override
    public boolean readable() {
        return false;
    }

    @Override
    @NonNull
    public DataBuf content() {
        throw new UnsupportedOperationException("Empty packet has no buffer.");
    }

    @Override
    @NonNull
    public Instant creation() {
        return Instant.EPOCH;
    }
}

