/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.driver.network.netty.server;

import eu.cloudnetservice.common.concurrent.Task;
import eu.cloudnetservice.driver.ComponentInfo;
import eu.cloudnetservice.driver.event.EventManager;
import eu.cloudnetservice.driver.network.DefaultNetworkComponent;
import eu.cloudnetservice.driver.network.HostAndPort;
import eu.cloudnetservice.driver.network.NetworkChannel;
import eu.cloudnetservice.driver.network.NetworkChannelHandler;
import eu.cloudnetservice.driver.network.NetworkServer;
import eu.cloudnetservice.driver.network.netty.NettyOptionSettingChannelInitializer;
import eu.cloudnetservice.driver.network.netty.NettySslServer;
import eu.cloudnetservice.driver.network.netty.NettyUtil;
import eu.cloudnetservice.driver.network.netty.server.NettyNetworkServerInitializer;
import eu.cloudnetservice.driver.network.protocol.Packet;
import eu.cloudnetservice.driver.network.protocol.PacketListenerRegistry;
import eu.cloudnetservice.driver.network.protocol.defaults.DefaultPacketListenerRegistry;
import eu.cloudnetservice.driver.network.ssl.SSLConfiguration;
import io.netty5.bootstrap.ServerBootstrap;
import io.netty5.channel.Channel;
import io.netty5.channel.ChannelHandler;
import io.netty5.channel.ChannelOption;
import io.netty5.channel.EventLoopGroup;
import io.netty5.channel.WriteBufferWaterMark;
import io.netty5.channel.unix.UnixChannelOption;
import io.netty5.util.concurrent.Future;
import jakarta.inject.Singleton;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import lombok.NonNull;
import org.jetbrains.annotations.Nullable;

@Singleton
public class NettyNetworkServer
extends NettySslServer
implements DefaultNetworkComponent,
NetworkServer {
    protected static final WriteBufferWaterMark WATER_MARK = new WriteBufferWaterMark(0x100000, 0x200000);
    protected final EventLoopGroup bossEventLoopGroup = NettyUtil.newEventLoopGroup(1);
    protected final EventLoopGroup workerEventLoopGroup = NettyUtil.newEventLoopGroup(0);
    protected final Collection<NetworkChannel> channels = ConcurrentHashMap.newKeySet();
    protected final Map<HostAndPort, Future<Void>> channelFutures = new ConcurrentHashMap<HostAndPort, Future<Void>>();
    protected final PacketListenerRegistry packetRegistry = new DefaultPacketListenerRegistry();
    protected final EventManager eventManager;
    protected final Executor packetDispatcher;
    protected final Callable<NetworkChannelHandler> handlerFactory;

    public NettyNetworkServer(@NonNull EventManager eventManager, @NonNull ComponentInfo componentInfo, @NonNull Callable<NetworkChannelHandler> handlerFactory) {
        this(eventManager, componentInfo, handlerFactory, null);
        if (eventManager == null) {
            throw new NullPointerException("eventManager is marked non-null but is null");
        }
        if (componentInfo == null) {
            throw new NullPointerException("componentInfo is marked non-null but is null");
        }
        if (handlerFactory == null) {
            throw new NullPointerException("handlerFactory is marked non-null but is null");
        }
    }

    public NettyNetworkServer(@NonNull EventManager eventManager, @NonNull ComponentInfo componentInfo, @NonNull Callable<NetworkChannelHandler> handlerFactory, @Nullable SSLConfiguration sslConfiguration) {
        super(sslConfiguration);
        if (eventManager == null) {
            throw new NullPointerException("eventManager is marked non-null but is null");
        }
        if (componentInfo == null) {
            throw new NullPointerException("componentInfo is marked non-null but is null");
        }
        if (handlerFactory == null) {
            throw new NullPointerException("handlerFactory is marked non-null but is null");
        }
        this.eventManager = eventManager;
        this.handlerFactory = handlerFactory;
        this.packetDispatcher = NettyUtil.newPacketDispatcher(componentInfo.environment());
        try {
            this.init();
        }
        catch (Exception exception) {
            LOGGER.severe("Exception while initializing the netty network server", (Throwable)exception, new Object[0]);
        }
    }

    @Override
    public boolean sslEnabled() {
        return this.sslContext != null;
    }

    @Override
    @NonNull
    public Task<Void> addListener(int port) {
        return this.addListener(new HostAndPort("0.0.0.0", port));
    }

    @Override
    @NonNull
    public Task<Void> addListener(@NonNull HostAndPort hostAndPort) {
        if (hostAndPort == null) {
            throw new NullPointerException("hostAndPort is marked non-null but is null");
        }
        Task result = new Task();
        ((ServerBootstrap)new ServerBootstrap().channelFactory(NettyUtil.serverChannelFactory()).group(this.bossEventLoopGroup, this.workerEventLoopGroup).handler((ChannelHandler)new NettyOptionSettingChannelInitializer().option(ChannelOption.TCP_FASTOPEN, 3).option(ChannelOption.SO_REUSEADDR, true).option(UnixChannelOption.SO_REUSEPORT, true))).childHandler((ChannelHandler)new NettyNetworkServerInitializer(this.eventManager, this, hostAndPort).option(ChannelOption.IP_TOS, 24).option(ChannelOption.AUTO_READ, true).option(ChannelOption.TCP_NODELAY, true).option(ChannelOption.SO_REUSEADDR, true).option(ChannelOption.SO_KEEPALIVE, true).option(ChannelOption.WRITE_BUFFER_WATER_MARK, WATER_MARK)).bind(hostAndPort.host(), hostAndPort.port()).addListener(future -> {
            if (future.isSuccess()) {
                result.complete(null);
                this.channelFutures.put(hostAndPort, (Future<Void>)((Channel)future.getNow()).closeFuture());
            } else {
                result.completeExceptionally(future.cause());
            }
        });
        return result;
    }

    @Override
    public void close() {
        this.closeChannels();
        for (Future<Void> entry : this.channelFutures.values()) {
            entry.cancel();
        }
        this.bossEventLoopGroup.shutdownGracefully();
        this.workerEventLoopGroup.shutdownGracefully();
    }

    @Override
    @NonNull
    public Collection<NetworkChannel> channels() {
        return Collections.unmodifiableCollection(this.channels);
    }

    @Override
    @NonNull
    public Executor packetDispatcher() {
        return this.packetDispatcher;
    }

    @Override
    @NonNull
    public Collection<NetworkChannel> modifiableChannels() {
        return this.channels;
    }

    @Override
    public void sendPacketSync(Packet ... packets) {
        if (packets == null) {
            throw new NullPointerException("packets is marked non-null but is null");
        }
        for (NetworkChannel channel : this.channels) {
            channel.sendPacketSync(packets);
        }
    }

    @Override
    @NonNull
    public PacketListenerRegistry packetRegistry() {
        return this.packetRegistry;
    }
}

