/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.driver.network.netty.http;

import eu.cloudnetservice.common.log.LogManager;
import eu.cloudnetservice.common.log.Logger;
import eu.cloudnetservice.driver.network.http.websocket.WebSocketFrameType;
import eu.cloudnetservice.driver.network.http.websocket.WebSocketListener;
import eu.cloudnetservice.driver.network.netty.http.NettyWebSocketServerChannel;
import io.netty5.channel.ChannelHandlerContext;
import io.netty5.channel.SimpleChannelInboundHandler;
import io.netty5.handler.codec.http.websocketx.BinaryWebSocketFrame;
import io.netty5.handler.codec.http.websocketx.CloseWebSocketFrame;
import io.netty5.handler.codec.http.websocketx.PingWebSocketFrame;
import io.netty5.handler.codec.http.websocketx.PongWebSocketFrame;
import io.netty5.handler.codec.http.websocketx.TextWebSocketFrame;
import io.netty5.handler.codec.http.websocketx.WebSocketFrame;
import java.io.IOException;
import lombok.NonNull;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
final class NettyWebSocketServerChannelHandler
extends SimpleChannelInboundHandler<WebSocketFrame> {
    private static final Logger LOGGER = LogManager.logger(NettyWebSocketServerChannelHandler.class);
    private final NettyWebSocketServerChannel webSocketServerChannel;

    public NettyWebSocketServerChannelHandler(@NonNull NettyWebSocketServerChannel webSocketServerChannel) {
        if (webSocketServerChannel == null) {
            throw new NullPointerException("webSocketServerChannel is marked non-null but is null");
        }
        this.webSocketServerChannel = webSocketServerChannel;
    }

    public void channelExceptionCaught(@NonNull ChannelHandlerContext ctx, @NonNull Throwable cause) {
        if (ctx == null) {
            throw new NullPointerException("ctx is marked non-null but is null");
        }
        if (cause == null) {
            throw new NullPointerException("cause is marked non-null but is null");
        }
        if (!(cause instanceof IOException)) {
            LOGGER.severe("Exception was caught", cause, new Object[0]);
        }
    }

    public void channelReadComplete(@NonNull ChannelHandlerContext ctx) {
        if (ctx == null) {
            throw new NullPointerException("ctx is marked non-null but is null");
        }
        ctx.flush();
    }

    public void channelInactive(@NonNull ChannelHandlerContext ctx) {
        if (ctx == null) {
            throw new NullPointerException("ctx is marked non-null but is null");
        }
        if (!(ctx.channel().isActive() && ctx.channel().isOpen() && ctx.channel().isWritable())) {
            ctx.channel().close();
        }
    }

    protected void messageReceived(@NonNull ChannelHandlerContext ctx, @NonNull WebSocketFrame webSocketFrame) {
        if (ctx == null) {
            throw new NullPointerException("ctx is marked non-null but is null");
        }
        if (webSocketFrame == null) {
            throw new NullPointerException("webSocketFrame is marked non-null but is null");
        }
        if (webSocketFrame instanceof PingWebSocketFrame) {
            this.invoke0(WebSocketFrameType.PING, webSocketFrame);
        }
        if (webSocketFrame instanceof PongWebSocketFrame) {
            this.invoke0(WebSocketFrameType.PONG, webSocketFrame);
        }
        if (webSocketFrame instanceof TextWebSocketFrame) {
            this.invoke0(WebSocketFrameType.TEXT, webSocketFrame);
        }
        if (webSocketFrame instanceof BinaryWebSocketFrame) {
            this.invoke0(WebSocketFrameType.BINARY, webSocketFrame);
        }
        if (webSocketFrame instanceof CloseWebSocketFrame) {
            CloseWebSocketFrame frame = (CloseWebSocketFrame)webSocketFrame;
            this.webSocketServerChannel.close(frame.statusCode(), frame.reasonText());
        }
    }

    private void invoke0(@NonNull WebSocketFrameType type, @NonNull WebSocketFrame webSocketFrame) {
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        if (webSocketFrame == null) {
            throw new NullPointerException("webSocketFrame is marked non-null but is null");
        }
        byte[] bytes = this.readContentFromWebSocketFrame(webSocketFrame);
        for (WebSocketListener listener : this.webSocketServerChannel.listeners()) {
            try {
                listener.handle(this.webSocketServerChannel, type, bytes);
            }
            catch (Exception exception) {
                LOGGER.severe("Exception while invoking handle", (Throwable)exception, new Object[0]);
            }
        }
    }

    private byte[] readContentFromWebSocketFrame(@NonNull WebSocketFrame frame) {
        if (frame == null) {
            throw new NullPointerException("frame is marked non-null but is null");
        }
        byte[] bytes = new byte[frame.binaryData().readableBytes()];
        frame.binaryData().readBytes(bytes, 0, bytes.length);
        return bytes;
    }
}

