/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.driver.network.netty.http;

import io.netty5.channel.ChannelHandlerContext;
import io.netty5.handler.timeout.IdleState;
import io.netty5.handler.timeout.IdleStateEvent;
import io.netty5.handler.timeout.IdleStateHandler;
import io.netty5.handler.timeout.ReadTimeoutException;
import java.util.concurrent.TimeUnit;
import lombok.NonNull;

final class NettyIdleStateHandler
extends IdleStateHandler {
    private boolean closed = false;

    public NettyIdleStateHandler(int timeoutSeconds) {
        super(0L, 0L, (long)timeoutSeconds, TimeUnit.SECONDS);
    }

    protected void channelIdle(@NonNull ChannelHandlerContext ctx, @NonNull IdleStateEvent evt) {
        if (ctx == null) {
            throw new NullPointerException("ctx is marked non-null but is null");
        }
        if (evt == null) {
            throw new NullPointerException("evt is marked non-null but is null");
        }
        if (!this.closed && evt.state() == IdleState.ALL_IDLE) {
            ctx.fireChannelExceptionCaught((Throwable)ReadTimeoutException.INSTANCE);
            ctx.close();
            this.closed = true;
        }
    }
}

