/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.driver.network.netty.http;

import com.google.common.primitives.Ints;
import eu.cloudnetservice.driver.network.http.HttpContext;
import eu.cloudnetservice.driver.network.http.HttpResponse;
import eu.cloudnetservice.driver.network.http.HttpResponseCode;
import eu.cloudnetservice.driver.network.http.HttpVersion;
import eu.cloudnetservice.driver.network.netty.http.NettyHttpMessage;
import eu.cloudnetservice.driver.network.netty.http.NettyHttpServerContext;
import io.netty5.buffer.Buffer;
import io.netty5.buffer.DefaultBufferAllocators;
import io.netty5.handler.codec.http.DefaultFullHttpResponse;
import io.netty5.handler.codec.http.FullHttpResponse;
import io.netty5.handler.codec.http.HttpRequest;
import io.netty5.handler.codec.http.HttpResponseStatus;
import io.netty5.handler.codec.http.headers.HttpHeaders;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import lombok.NonNull;
import org.jetbrains.annotations.Nullable;

final class NettyHttpServerResponse
extends NettyHttpMessage
implements HttpResponse {
    final FullHttpResponse httpResponse;
    private final NettyHttpServerContext context;
    private InputStream responseInputStream;

    public NettyHttpServerResponse(@NonNull NettyHttpServerContext context, @NonNull HttpRequest httpRequest) {
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        if (httpRequest == null) {
            throw new NullPointerException("httpRequest is marked non-null but is null");
        }
        this.context = context;
        this.httpResponse = new DefaultFullHttpResponse(httpRequest.protocolVersion(), HttpResponseStatus.NOT_FOUND, DefaultBufferAllocators.offHeapAllocator().allocate(0));
    }

    @Override
    @NonNull
    public HttpResponseCode status() {
        return HttpResponseCode.fromNumeric(this.httpResponse.status().code());
    }

    @Override
    @NonNull
    public HttpResponse status(@NonNull HttpResponseCode code) {
        if (code == null) {
            throw new NullPointerException("code is marked non-null but is null");
        }
        this.httpResponse.setStatus(HttpResponseStatus.valueOf((int)code.code()));
        return this;
    }

    @Override
    @NonNull
    public HttpContext context() {
        return this.context;
    }

    @Override
    @Nullable
    public String header(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        CharSequence headerValue = this.httpResponse.headers().get((CharSequence)name);
        return headerValue == null ? null : headerValue.toString();
    }

    @Override
    @Nullable
    public Integer headerAsInt(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        String headerValue = this.header(name);
        return headerValue == null ? null : Ints.tryParse((String)headerValue);
    }

    @Override
    public boolean headerAsBoolean(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        String headerValue = this.header(name);
        return Boolean.parseBoolean(headerValue);
    }

    @Override
    @NonNull
    public HttpResponse header(@NonNull String name, @NonNull String value) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        this.httpResponse.headers().set((CharSequence)name, (CharSequence)value);
        return this;
    }

    @Override
    @NonNull
    public HttpResponse removeHeader(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        this.httpResponse.headers().remove((CharSequence)name);
        return this;
    }

    @Override
    @NonNull
    public HttpResponse clearHeaders() {
        this.httpResponse.headers().clear();
        return this;
    }

    @Override
    public boolean hasHeader(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        return this.httpResponse.headers().contains((CharSequence)name);
    }

    @Override
    @NonNull
    public Map<String, String> headers() {
        HttpHeaders headers = this.httpResponse.headers();
        HashMap<String, String> headerMap = new HashMap<String, String>(headers.size() + 1, 1.0f);
        for (Map.Entry entry : headers) {
            headerMap.put(((CharSequence)entry.getKey()).toString(), ((CharSequence)entry.getValue()).toString());
        }
        return headerMap;
    }

    @Override
    @NonNull
    public HttpVersion version() {
        return super.versionFromNetty(this.httpResponse.protocolVersion());
    }

    @Override
    @NonNull
    public HttpResponse version(@NonNull HttpVersion version) {
        if (version == null) {
            throw new NullPointerException("version is marked non-null but is null");
        }
        this.httpResponse.setProtocolVersion(super.versionToNetty(version));
        return this;
    }

    @Override
    public byte[] body() {
        Buffer payload = this.httpResponse.payload();
        int length = payload.readableBytes();
        byte[] body = new byte[length];
        payload.copyInto(payload.readerOffset(), body, 0, length);
        return body;
    }

    @Override
    @NonNull
    public String bodyAsString() {
        return new String(this.body(), StandardCharsets.UTF_8);
    }

    @Override
    @NonNull
    public HttpResponse body(byte[] byteArray) {
        this.httpResponse.payload().resetOffsets().fill((byte)0).writeBytes(byteArray);
        return this;
    }

    @Override
    @NonNull
    public HttpResponse body(@NonNull String text) {
        if (text == null) {
            throw new NullPointerException("text is marked non-null but is null");
        }
        return this.body(text.getBytes(StandardCharsets.UTF_8));
    }

    @Override
    public InputStream bodyStream() {
        return this.responseInputStream;
    }

    @Override
    @NonNull
    public HttpResponse body(InputStream body) {
        if (this.responseInputStream != null) {
            try {
                this.responseInputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.responseInputStream = body;
        return this;
    }

    @Override
    public boolean hasBody() {
        return this.httpResponse.payload().readableBytes() > 0 || this.responseInputStream != null;
    }
}

