/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.driver.network.netty.http;

import eu.cloudnetservice.common.log.LogManager;
import eu.cloudnetservice.common.log.Logger;
import eu.cloudnetservice.common.util.StringUtil;
import eu.cloudnetservice.driver.network.HostAndPort;
import eu.cloudnetservice.driver.network.http.HttpContext;
import eu.cloudnetservice.driver.network.http.HttpContextPreprocessor;
import eu.cloudnetservice.driver.network.http.HttpHandleException;
import eu.cloudnetservice.driver.network.http.HttpResponseCode;
import eu.cloudnetservice.driver.network.netty.http.NettyHttpChannel;
import eu.cloudnetservice.driver.network.netty.http.NettyHttpServer;
import eu.cloudnetservice.driver.network.netty.http.NettyHttpServerContext;
import eu.cloudnetservice.driver.network.netty.http.NettyHttpServerResponse;
import io.netty5.channel.Channel;
import io.netty5.channel.ChannelFutureListeners;
import io.netty5.channel.ChannelHandlerContext;
import io.netty5.channel.SimpleChannelInboundHandler;
import io.netty5.handler.codec.http.DefaultHttpResponse;
import io.netty5.handler.codec.http.EmptyLastHttpContent;
import io.netty5.handler.codec.http.FullHttpResponse;
import io.netty5.handler.codec.http.HttpChunkedInput;
import io.netty5.handler.codec.http.HttpHeaderNames;
import io.netty5.handler.codec.http.HttpHeaderValues;
import io.netty5.handler.codec.http.HttpMessage;
import io.netty5.handler.codec.http.HttpRequest;
import io.netty5.handler.codec.http.HttpResponseStatus;
import io.netty5.handler.codec.http.HttpUtil;
import io.netty5.handler.codec.http.LastHttpContent;
import io.netty5.handler.stream.ChunkedInput;
import io.netty5.handler.stream.ChunkedStream;
import io.netty5.handler.timeout.ReadTimeoutException;
import io.netty5.util.concurrent.Future;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Objects;
import lombok.NonNull;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
final class NettyHttpServerHandler
extends SimpleChannelInboundHandler<HttpRequest> {
    private static final Logger LOGGER = LogManager.logger(NettyHttpServerHandler.class);
    private final NettyHttpServer nettyHttpServer;
    private final HostAndPort connectedAddress;
    private NettyHttpChannel channel;

    public NettyHttpServerHandler(@NonNull NettyHttpServer nettyHttpServer, @NonNull HostAndPort connectedAddress) {
        if (nettyHttpServer == null) {
            throw new NullPointerException("nettyHttpServer is marked non-null but is null");
        }
        if (connectedAddress == null) {
            throw new NullPointerException("connectedAddress is marked non-null but is null");
        }
        this.nettyHttpServer = nettyHttpServer;
        this.connectedAddress = connectedAddress;
    }

    public void channelActive(@NonNull ChannelHandlerContext ctx) {
        if (ctx == null) {
            throw new NullPointerException("ctx is marked non-null but is null");
        }
        this.channel = new NettyHttpChannel(ctx.channel(), this.connectedAddress, HostAndPort.fromSocketAddress(ctx.channel().remoteAddress()));
    }

    public void channelInactive(@NonNull ChannelHandlerContext ctx) {
        if (ctx == null) {
            throw new NullPointerException("ctx is marked non-null but is null");
        }
        if (!(ctx.channel().isActive() && ctx.channel().isOpen() && ctx.channel().isWritable())) {
            ctx.channel().close();
        }
    }

    public void channelExceptionCaught(@NonNull ChannelHandlerContext ctx, @NonNull Throwable cause) {
        if (ctx == null) {
            throw new NullPointerException("ctx is marked non-null but is null");
        }
        if (cause == null) {
            throw new NullPointerException("cause is marked non-null but is null");
        }
        if (!(cause instanceof IOException) && !(cause instanceof ReadTimeoutException)) {
            LOGGER.severe("Exception caught during processing of http request", cause, new Object[0]);
        }
    }

    public void channelReadComplete(@NonNull ChannelHandlerContext ctx) {
        if (ctx == null) {
            throw new NullPointerException("ctx is marked non-null but is null");
        }
        ctx.flush();
    }

    protected void messageReceived(@NonNull ChannelHandlerContext ctx, @NonNull HttpRequest msg) {
        if (ctx == null) {
            throw new NullPointerException("ctx is marked non-null but is null");
        }
        if (msg == null) {
            throw new NullPointerException("msg is marked non-null but is null");
        }
        if (msg.decoderResult().isFailure()) {
            ctx.channel().close();
            return;
        }
        this.handleMessage(ctx.channel(), msg);
    }

    private void handleMessage(@NonNull Channel channel, @NonNull HttpRequest httpRequest) {
        if (channel == null) {
            throw new NullPointerException("channel is marked non-null but is null");
        }
        if (httpRequest == null) {
            throw new NullPointerException("httpRequest is marked non-null but is null");
        }
        URI uri = URI.create(httpRequest.uri());
        if (uri.isOpaque()) {
            channel.writeAndFlush((Object)new DefaultHttpResponse(httpRequest.protocolVersion(), HttpResponseStatus.BAD_REQUEST)).addListener((Object)channel, ChannelFutureListeners.CLOSE);
            return;
        }
        String fullPath = uri.getPath();
        if (!fullPath.equals("/") && fullPath.endsWith("/")) {
            fullPath = fullPath.substring(0, fullPath.length() - 1);
        }
        ArrayList<NettyHttpServer.HttpHandlerEntry> entries = new ArrayList<NettyHttpServer.HttpHandlerEntry>(this.nettyHttpServer.registeredHandlers);
        entries.sort(Comparator.comparingInt(NettyHttpServer.HttpHandlerEntry::priority).reversed());
        String[] pathEntries = fullPath.split("/");
        NettyHttpServerContext context = new NettyHttpServerContext(this.nettyHttpServer, this.channel, uri, new HashMap<String, String>(), httpRequest);
        for (NettyHttpServer.HttpHandlerEntry httpHandlerEntry : entries) {
            context.invocationHints.clear();
            context.pathPrefix(httpHandlerEntry.path());
            String[] handlerPathEntries = httpHandlerEntry.path().split("/");
            if (!this.handleMessage0(httpHandlerEntry, context, fullPath, pathEntries, handlerPathEntries)) continue;
            context.pushChain(httpHandlerEntry.httpHandler());
            if (!context.cancelNext) continue;
            break;
        }
        if (!context.cancelSendResponse) {
            Future future;
            NettyHttpServerResponse response = context.httpServerResponse;
            if (response.status() == HttpResponseCode.NOT_FOUND && !response.hasBody()) {
                response.body("Resource not found!");
            }
            FullHttpResponse netty = response.httpResponse;
            if (!context.closeAfter) {
                netty.headers().set((CharSequence)HttpHeaderNames.CONNECTION, (CharSequence)HttpHeaderValues.KEEP_ALIVE);
            }
            if (response.bodyStream() != null) {
                HttpUtil.setTransferEncodingChunked((HttpMessage)netty, (boolean)true);
                channel.write((Object)new DefaultHttpResponse(netty.protocolVersion(), netty.status(), netty.headers()));
                future = channel.writeAndFlush((Object)new HttpChunkedInput((ChunkedInput)new ChunkedStream(response.bodyStream()), (LastHttpContent)new EmptyLastHttpContent(channel.bufferAllocator())));
            } else {
                HttpUtil.setTransferEncodingChunked((HttpMessage)netty, (boolean)false);
                HttpUtil.setContentLength((HttpMessage)netty, (long)netty.payload().readableBytes());
                future = channel.writeAndFlush((Object)netty);
            }
            future.addListener((Object)channel, ChannelFutureListeners.FIRE_EXCEPTION_ON_FAILURE);
            if (context.closeAfter) {
                future.addListener((Object)channel, ChannelFutureListeners.CLOSE);
            }
        }
    }

    private boolean handleMessage0(@NonNull NettyHttpServer.HttpHandlerEntry httpHandlerEntry, @NonNull HttpContext context, @NonNull String fullPath, @NonNull String[] pathEntries, @NonNull String[] handlerPathEntries) {
        Collection<HttpContextPreprocessor> preprocessors;
        if (httpHandlerEntry == null) {
            throw new NullPointerException("httpHandlerEntry is marked non-null but is null");
        }
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        if (fullPath == null) {
            throw new NullPointerException("fullPath is marked non-null but is null");
        }
        if (pathEntries == null) {
            throw new NullPointerException("pathEntries is marked non-null but is null");
        }
        if (handlerPathEntries == null) {
            throw new NullPointerException("handlerPathEntries is marked non-null but is null");
        }
        String path = StringUtil.toLower((String)fullPath);
        if (httpHandlerEntry.port() != null && httpHandlerEntry.port().intValue() != this.connectedAddress.port()) {
            return false;
        }
        if (!httpHandlerEntry.path().endsWith("*") && pathEntries.length != handlerPathEntries.length) {
            return false;
        }
        if (pathEntries.length < handlerPathEntries.length) {
            return false;
        }
        if (pathEntries.length != 1 || handlerPathEntries.length != 1) {
            for (int index = 1; index < pathEntries.length; ++index) {
                String entry = handlerPathEntries[index];
                if (entry.equals("*")) {
                    if (handlerPathEntries.length - 1 != index) continue;
                    break;
                }
                if (entry.startsWith("{") && entry.endsWith("}") && entry.length() > 2) {
                    context.request().pathParameters().put(entry.substring(1, entry.length() - 1), pathEntries[index]);
                    continue;
                }
                if (entry.equals(pathEntries[index])) continue;
                return false;
            }
        }
        if (!(preprocessors = httpHandlerEntry.httpHandler().preprocessors()).isEmpty()) {
            for (HttpContextPreprocessor preprocessor : preprocessors) {
                context = preprocessor.preProcessContext(path, context);
                if (context != null) continue;
                return false;
            }
        }
        try {
            httpHandlerEntry.httpHandler().handle(path, context);
            return true;
        }
        catch (Throwable throwable) {
            if (throwable instanceof HttpHandleException) {
                HttpHandleException handleException = (HttpHandleException)throwable;
                context.response().status(handleException.responseCode()).body(Objects.requireNonNullElse(handleException.responseBody(), new byte[0]));
                return false;
            }
            LOGGER.finer("Exception posting http request to handler %s", throwable, new Object[]{httpHandlerEntry.httpHandler().getClass().getName()});
            context.response().status(HttpResponseCode.BAD_REQUEST);
            return false;
        }
    }
}

