/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.driver.network.netty.http;

import eu.cloudnetservice.common.concurrent.Task;
import eu.cloudnetservice.common.log.LogManager;
import eu.cloudnetservice.common.log.Logger;
import eu.cloudnetservice.driver.network.HostAndPort;
import eu.cloudnetservice.driver.network.http.HttpHandler;
import eu.cloudnetservice.driver.network.http.HttpServer;
import eu.cloudnetservice.driver.network.http.annotation.parser.DefaultHttpAnnotationParser;
import eu.cloudnetservice.driver.network.http.annotation.parser.HttpAnnotationParser;
import eu.cloudnetservice.driver.network.netty.NettySslServer;
import eu.cloudnetservice.driver.network.netty.NettyUtil;
import eu.cloudnetservice.driver.network.netty.http.NettyHttpServerInitializer;
import eu.cloudnetservice.driver.network.ssl.SSLConfiguration;
import io.netty5.bootstrap.ServerBootstrap;
import io.netty5.channel.Channel;
import io.netty5.channel.ChannelHandler;
import io.netty5.channel.ChannelOption;
import io.netty5.channel.EventLoopGroup;
import io.netty5.util.concurrent.Future;
import jakarta.inject.Singleton;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import lombok.NonNull;
import org.jetbrains.annotations.Nullable;

@Singleton
public class NettyHttpServer
extends NettySslServer
implements HttpServer {
    private static final Logger LOGGER = LogManager.logger(NettyHttpServer.class);
    protected final Map<HostAndPort, Future<Void>> channelFutures = new ConcurrentHashMap<HostAndPort, Future<Void>>();
    protected final Collection<HttpHandlerEntry> registeredHandlers = ConcurrentHashMap.newKeySet();
    protected final EventLoopGroup bossGroup = NettyUtil.newEventLoopGroup(1);
    protected final EventLoopGroup workerGroup = NettyUtil.newEventLoopGroup(0);
    protected final HttpAnnotationParser<HttpServer> annoParser = DefaultHttpAnnotationParser.withDefaultProcessors(this);

    public NettyHttpServer() {
        this(null);
    }

    public NettyHttpServer(@Nullable SSLConfiguration sslConfiguration) {
        super(sslConfiguration);
        try {
            this.init();
        }
        catch (Exception exception) {
            LOGGER.severe("Exception initializing web server", (Throwable)exception, new Object[0]);
        }
    }

    @Override
    public boolean sslEnabled() {
        return this.sslContext != null;
    }

    @Override
    @NonNull
    public HttpAnnotationParser<HttpServer> annotationParser() {
        return this.annoParser;
    }

    @Override
    @NonNull
    public Task<Void> addListener(int port) {
        return this.addListener(new HostAndPort("0.0.0.0", port));
    }

    @Override
    @NonNull
    public Task<Void> addListener(@NonNull HostAndPort hostAndPort) {
        if (hostAndPort == null) {
            throw new NullPointerException("hostAndPort is marked non-null but is null");
        }
        Task result = new Task();
        ((ServerBootstrap)new ServerBootstrap().group(this.bossGroup, this.workerGroup).channelFactory(NettyUtil.serverChannelFactory()).childHandler((ChannelHandler)new NettyHttpServerInitializer(this, hostAndPort)).childOption(ChannelOption.AUTO_READ, (Object)true).childOption(ChannelOption.TCP_NODELAY, (Object)true).childOption(ChannelOption.SO_REUSEADDR, (Object)true).option(ChannelOption.SO_REUSEADDR, (Object)true)).bind(hostAndPort.host(), hostAndPort.port()).addListener(future -> {
            if (future.isSuccess()) {
                result.complete(null);
                this.channelFutures.put(hostAndPort, (Future<Void>)((Channel)future.getNow()).closeFuture());
            } else {
                result.completeExceptionally(future.cause());
            }
        });
        return result;
    }

    @Override
    @NonNull
    public HttpServer registerHandler(@NonNull String path, HttpHandler ... handlers) {
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        return this.registerHandler(path, 32, handlers);
    }

    @Override
    @NonNull
    public HttpServer registerHandler(@NonNull String path, int priority, HttpHandler ... handlers) {
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        return this.registerHandler(path, null, priority, handlers);
    }

    @Override
    @NonNull
    public HttpServer registerHandler(@NonNull String path, @Nullable Integer port, int priority, HttpHandler ... handlers) {
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        if (handlers == null) {
            throw new NullPointerException("handlers is marked non-null but is null");
        }
        if (!((String)path).startsWith("/")) {
            path = "/" + (String)path;
        }
        if (((String)path).endsWith("/") && !((String)path).equals("/")) {
            path = ((String)path).substring(0, ((String)path).length() - 1);
        }
        for (HttpHandler httpHandler : handlers) {
            this.registeredHandlers.add(new HttpHandlerEntry((String)path, httpHandler, port, priority));
        }
        return this;
    }

    @Override
    @NonNull
    public HttpServer removeHandler(@NonNull HttpHandler handler) {
        if (handler == null) {
            throw new NullPointerException("handler is marked non-null but is null");
        }
        this.registeredHandlers.removeIf(registeredHandler -> registeredHandler.httpHandler.equals(handler));
        return this;
    }

    @Override
    @NonNull
    public HttpServer removeHandler(@NonNull ClassLoader classLoader) {
        if (classLoader == null) {
            throw new NullPointerException("classLoader is marked non-null but is null");
        }
        this.registeredHandlers.removeIf(handler -> handler.httpHandler.getClass().getClassLoader().equals(classLoader));
        return this;
    }

    @Override
    @NonNull
    public Collection<HttpHandler> httpHandlers() {
        return this.registeredHandlers.stream().map(HttpHandlerEntry::httpHandler).toList();
    }

    @Override
    @NonNull
    public HttpServer clearHandlers() {
        this.registeredHandlers.clear();
        return this;
    }

    @Override
    public void close() {
        for (Future<Void> entry : this.channelFutures.values()) {
            entry.cancel();
        }
        this.bossGroup.shutdownGracefully();
        this.workerGroup.shutdownGracefully();
        this.clearHandlers();
    }

    public record HttpHandlerEntry(@NonNull String path, @NonNull HttpHandler httpHandler, @Nullable Integer port, int priority) implements Comparable<HttpHandlerEntry>
    {
        public HttpHandlerEntry(@NonNull String path, @NonNull HttpHandler httpHandler, @Nullable Integer port, int priority) {
            if (path == null) {
                throw new NullPointerException("path is marked non-null but is null");
            }
            if (httpHandler == null) {
                throw new NullPointerException("httpHandler is marked non-null but is null");
            }
        }

        @Override
        public int compareTo(@NonNull HttpHandlerEntry httpHandlerEntry) {
            if (httpHandlerEntry == null) {
                throw new NullPointerException("httpHandlerEntry is marked non-null but is null");
            }
            return Integer.compare(this.priority, httpHandlerEntry.priority());
        }
    }
}

