/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.driver.network.netty.codec;

import eu.cloudnetservice.common.log.LogManager;
import eu.cloudnetservice.common.log.Logger;
import eu.cloudnetservice.driver.network.netty.NettyUtil;
import eu.cloudnetservice.driver.network.netty.buffer.NettyImmutableDataBuf;
import eu.cloudnetservice.driver.network.protocol.BasePacket;
import io.netty5.buffer.Buffer;
import io.netty5.channel.ChannelHandlerContext;
import io.netty5.handler.codec.ByteToMessageDecoder;
import java.util.UUID;
import lombok.NonNull;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public final class NettyPacketDecoder
extends ByteToMessageDecoder {
    private static final Logger LOGGER = LogManager.logger(NettyPacketDecoder.class);

    protected void decode(@NonNull ChannelHandlerContext ctx, @NonNull Buffer in) {
        if (ctx == null) {
            throw new NullPointerException("ctx is marked non-null but is null");
        }
        if (in == null) {
            throw new NullPointerException("in is marked non-null but is null");
        }
        if (!ctx.channel().isActive() || in.readableBytes() <= 0) {
            return;
        }
        try {
            int channel = NettyUtil.readVarInt(in);
            boolean prioritized = in.readBoolean();
            UUID queryUniqueId = in.readBoolean() ? new UUID(in.readLong(), in.readLong()) : null;
            int bodyLength = NettyUtil.readVarInt(in);
            NettyImmutableDataBuf body = new NettyImmutableDataBuf(in.copy(in.readerOffset(), bodyLength, true));
            in.skipReadableBytes(bodyLength);
            BasePacket packet = new BasePacket(channel, prioritized, body);
            packet.uniqueId(queryUniqueId);
            ctx.fireChannelRead((Object)packet);
        }
        catch (Exception exception) {
            LOGGER.severe("Exception while decoding packet", (Throwable)exception, new Object[0]);
        }
    }
}

