/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.driver.network.netty.client;

import eu.cloudnetservice.driver.event.EventManager;
import eu.cloudnetservice.driver.network.HostAndPort;
import eu.cloudnetservice.driver.network.netty.NettyOptionSettingChannelInitializer;
import eu.cloudnetservice.driver.network.netty.client.NettyNetworkClient;
import eu.cloudnetservice.driver.network.netty.client.NettyNetworkClientHandler;
import eu.cloudnetservice.driver.network.netty.codec.NettyPacketDecoder;
import eu.cloudnetservice.driver.network.netty.codec.NettyPacketEncoder;
import eu.cloudnetservice.driver.network.netty.codec.VarInt32FrameDecoder;
import eu.cloudnetservice.driver.network.netty.codec.VarInt32FramePrepender;
import io.netty5.channel.Channel;
import io.netty5.channel.ChannelHandler;
import lombok.NonNull;

public class NettyNetworkClientInitializer
extends NettyOptionSettingChannelInitializer {
    protected final HostAndPort hostAndPort;
    protected final EventManager eventManager;
    protected final NettyNetworkClient nettyNetworkClient;

    public NettyNetworkClientInitializer(@NonNull HostAndPort targetHost, @NonNull EventManager eventManager, @NonNull NettyNetworkClient networkClient) {
        if (targetHost == null) {
            throw new NullPointerException("targetHost is marked non-null but is null");
        }
        if (eventManager == null) {
            throw new NullPointerException("eventManager is marked non-null but is null");
        }
        if (networkClient == null) {
            throw new NullPointerException("networkClient is marked non-null but is null");
        }
        this.hostAndPort = targetHost;
        this.eventManager = eventManager;
        this.nettyNetworkClient = networkClient;
    }

    @Override
    protected void doInitChannel(@NonNull Channel channel) {
        if (channel == null) {
            throw new NullPointerException("channel is marked non-null but is null");
        }
        if (this.nettyNetworkClient.sslContext != null) {
            channel.pipeline().addLast("ssl-handler", (ChannelHandler)this.nettyNetworkClient.sslContext.newHandler(channel.bufferAllocator(), this.hostAndPort.host(), this.hostAndPort.port()));
        }
        channel.pipeline().addLast("packet-length-deserializer", (ChannelHandler)new VarInt32FrameDecoder()).addLast("packet-decoder", (ChannelHandler)new NettyPacketDecoder()).addLast("packet-length-serializer", (ChannelHandler)VarInt32FramePrepender.INSTANCE).addLast("packet-encoder", (ChannelHandler)NettyPacketEncoder.INSTANCE).addLast("network-client-handler", (ChannelHandler)new NettyNetworkClientHandler(this.eventManager, this.nettyNetworkClient, this.hostAndPort));
    }
}

