/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.driver.network.netty.client;

import eu.cloudnetservice.driver.event.EventManager;
import eu.cloudnetservice.driver.network.HostAndPort;
import eu.cloudnetservice.driver.network.NetworkChannel;
import eu.cloudnetservice.driver.network.netty.NettyNetworkChannel;
import eu.cloudnetservice.driver.network.netty.NettyNetworkHandler;
import eu.cloudnetservice.driver.network.netty.client.NettyNetworkClient;
import io.netty5.channel.ChannelHandlerContext;
import java.util.Collection;
import java.util.concurrent.Executor;
import lombok.NonNull;

public class NettyNetworkClientHandler
extends NettyNetworkHandler {
    private final HostAndPort connectedAddress;
    private final NettyNetworkClient nettyNetworkClient;

    public NettyNetworkClientHandler(@NonNull EventManager eventManager, @NonNull NettyNetworkClient nettyNetworkClient, @NonNull HostAndPort connectedAddress) {
        super(eventManager);
        if (eventManager == null) {
            throw new NullPointerException("eventManager is marked non-null but is null");
        }
        if (nettyNetworkClient == null) {
            throw new NullPointerException("nettyNetworkClient is marked non-null but is null");
        }
        if (connectedAddress == null) {
            throw new NullPointerException("connectedAddress is marked non-null but is null");
        }
        this.nettyNetworkClient = nettyNetworkClient;
        this.connectedAddress = connectedAddress;
    }

    public void channelActive(@NonNull ChannelHandlerContext ctx) throws Exception {
        if (ctx == null) {
            throw new NullPointerException("ctx is marked non-null but is null");
        }
        this.channel = new NettyNetworkChannel(ctx.channel(), this.eventManager, this.nettyNetworkClient.packetRegistry(), this.nettyNetworkClient.handlerFactory.call(), this.connectedAddress, HostAndPort.fromSocketAddress(ctx.channel().localAddress()), true);
        this.nettyNetworkClient.channels.add(this.channel);
        this.channel.handler().handleChannelInitialize(this.channel);
    }

    @Override
    @NonNull
    protected Collection<NetworkChannel> channels() {
        return this.nettyNetworkClient.channels;
    }

    @Override
    @NonNull
    protected Executor packetDispatcher() {
        return this.nettyNetworkClient.packetDispatcher();
    }
}

