/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.driver.network.netty.buffer;

import com.google.common.base.Preconditions;
import dev.derklaro.aerogel.auto.Provides;
import eu.cloudnetservice.driver.network.buffer.DataBuf;
import eu.cloudnetservice.driver.network.buffer.DataBufFactory;
import eu.cloudnetservice.driver.network.netty.buffer.NettyImmutableDataBuf;
import eu.cloudnetservice.driver.network.netty.buffer.NettyMutableDataBuf;
import io.netty5.buffer.Buffer;
import io.netty5.buffer.BufferAllocator;
import io.netty5.buffer.DefaultBufferAllocators;
import jakarta.inject.Singleton;
import lombok.NonNull;

@Singleton
@Provides(value={DataBufFactory.class})
public class NettyDataBufFactory
implements DataBufFactory {
    public static final NettyDataBufFactory INSTANCE = new NettyDataBufFactory();
    protected static final BufferAllocator ALLOCATOR = DefaultBufferAllocators.offHeapAllocator();

    protected NettyDataBufFactory() {
    }

    @Override
    @NonNull
    public DataBuf.Mutable createEmpty() {
        return new NettyMutableDataBuf(ALLOCATOR.allocate(0));
    }

    @Override
    @NonNull
    public DataBuf fromBytes(byte[] bytes) {
        return new NettyImmutableDataBuf(ALLOCATOR.copyOf(bytes));
    }

    @Override
    @NonNull
    public DataBuf copyOf(@NonNull DataBuf dataBuf) {
        if (dataBuf == null) {
            throw new NullPointerException("dataBuf is marked non-null but is null");
        }
        Preconditions.checkArgument((boolean)(dataBuf instanceof NettyImmutableDataBuf), (Object)"Factory only supports netty data buf copy");
        Buffer buffer = ((NettyImmutableDataBuf)dataBuf).buffer();
        return new NettyImmutableDataBuf(buffer.copy(0, buffer.readableBytes(), true));
    }

    @Override
    @NonNull
    public DataBuf.Mutable mutableCopyOf(@NonNull DataBuf dataBuf) {
        if (dataBuf == null) {
            throw new NullPointerException("dataBuf is marked non-null but is null");
        }
        Preconditions.checkArgument((boolean)(dataBuf instanceof NettyImmutableDataBuf), (Object)"Factory only supports netty data buf copy");
        Buffer buffer = ((NettyImmutableDataBuf)dataBuf).buffer();
        return new NettyMutableDataBuf(buffer.copy(0, buffer.readableBytes()));
    }

    @Override
    @NonNull
    public DataBuf.Mutable createWithExpectedSize(int byteSize) {
        return new NettyMutableDataBuf(ALLOCATOR.allocate(byteSize));
    }
}

