/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.driver.network.netty;

import eu.cloudnetservice.driver.DriverEnvironment;
import eu.cloudnetservice.driver.network.netty.NettyTransport;
import eu.cloudnetservice.driver.util.ExecutorServiceUtil;
import io.netty5.buffer.Buffer;
import io.netty5.buffer.BufferUtil;
import io.netty5.channel.Channel;
import io.netty5.channel.ChannelFactory;
import io.netty5.channel.EventLoopGroup;
import io.netty5.channel.ServerChannel;
import io.netty5.channel.ServerChannelFactory;
import io.netty5.handler.codec.DecoderException;
import io.netty5.util.ResourceLeakDetector;
import io.netty5.util.concurrent.Future;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import lombok.NonNull;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Range;

@ApiStatus.Internal
public final class NettyUtil {
    private static final int[] VAR_INT_BYTE_LENGTHS = new int[33];
    private static final boolean NO_NATIVE_TRANSPORT = Boolean.getBoolean("cloudnet.no-native");
    private static final NettyTransport CURR_NETTY_TRANSPORT = NettyTransport.availableTransport(NO_NATIVE_TRANSPORT);
    private static final RejectedExecutionHandler DEFAULT_REJECT_HANDLER = new ThreadPoolExecutor.CallerRunsPolicy();

    private NettyUtil() {
        throw new UnsupportedOperationException();
    }

    @NonNull
    public static Executor newPacketDispatcher(@NonNull DriverEnvironment driverEnvironment) {
        if (driverEnvironment == null) {
            throw new NullPointerException("driverEnvironment is marked non-null but is null");
        }
        int maximumPoolSize = NettyUtil.threadAmount(driverEnvironment);
        return ExecutorServiceUtil.newVirtualThreadExecutor("Packet-Dispatcher-", threadFactory -> new ThreadPoolExecutor(maximumPoolSize, maximumPoolSize, 30L, TimeUnit.SECONDS, (BlockingQueue<Runnable>)new LinkedBlockingQueue<Runnable>(), (ThreadFactory)threadFactory, DEFAULT_REJECT_HANDLER));
    }

    @NonNull
    public static EventLoopGroup newEventLoopGroup(int threads) {
        return CURR_NETTY_TRANSPORT.createEventLoopGroup(threads);
    }

    @NonNull
    public static ChannelFactory<? extends Channel> clientChannelFactory() {
        return CURR_NETTY_TRANSPORT.clientChannelFactory();
    }

    @NonNull
    public static ServerChannelFactory<? extends ServerChannel> serverChannelFactory() {
        return CURR_NETTY_TRANSPORT.serverChannelFactory();
    }

    @NonNull
    public static Buffer writeVarInt(@NonNull Buffer buffer, int value) {
        if (buffer == null) {
            throw new NullPointerException("buffer is marked non-null but is null");
        }
        while (true) {
            if ((value & 0xFFFFFF80) == 0) {
                buffer.writeByte((byte)value);
                return buffer;
            }
            buffer.writeByte((byte)(value & 0x7F | 0x80));
            value >>>= 7;
        }
    }

    public static int readVarInt(@NonNull Buffer buffer) {
        if (buffer == null) {
            throw new NullPointerException("buffer is marked non-null but is null");
        }
        Integer varInt = NettyUtil.readVarIntOrNull(buffer);
        if (varInt == null) {
            String bufferDump = BufferUtil.hexDump((Buffer)buffer, (int)0, (int)buffer.readableBytes());
            throw new DecoderException(String.format("Unable to decode VarInt at current buffer position (%d): %s", buffer.readerOffset(), bufferDump));
        }
        return varInt;
    }

    @Nullable
    public static Integer readVarIntOrNull(@NonNull Buffer buffer) {
        if (buffer == null) {
            throw new NullPointerException("buffer is marked non-null but is null");
        }
        int i = 0;
        int maxRead = Math.min(5, buffer.readableBytes());
        for (int j = 0; j < maxRead; ++j) {
            byte nextByte = buffer.readByte();
            i |= (nextByte & 0x7F) << j * 7;
            if ((nextByte & 0x80) == 128) continue;
            return i;
        }
        return null;
    }

    public static int varIntBytes(int contentLength) {
        return VAR_INT_BYTE_LENGTHS[Integer.numberOfLeadingZeros(contentLength)];
    }

    @NonNull
    public static <T> Future<T> awaitFuture(@NonNull Future<T> future) {
        if (future == null) {
            throw new NullPointerException("future is marked non-null but is null");
        }
        try {
            return future.asStage().sync().future();
        }
        catch (InterruptedException exception) {
            Thread.currentThread().interrupt();
            throw new IllegalThreadStateException();
        }
    }

    public static @Range(from=2L, to=0x7FFFFFFFL) int threadAmount(@NonNull DriverEnvironment environment) {
        if (environment == null) {
            throw new NullPointerException("environment is marked non-null but is null");
        }
        return environment.equals(DriverEnvironment.NODE) ? Math.max(8, Runtime.getRuntime().availableProcessors() * 2) : 4;
    }

    @NonNull
    public static NettyTransport selectedNettyTransport() {
        return CURR_NETTY_TRANSPORT;
    }

    static {
        if (System.getProperty("io.netty5.leakDetection.level") == null) {
            ResourceLeakDetector.setLevel((ResourceLeakDetector.Level)ResourceLeakDetector.Level.DISABLED);
        }
        for (int i = 0; i <= 32; ++i) {
            NettyUtil.VAR_INT_BYTE_LENGTHS[i] = (int)Math.ceil((31.0 - (double)(i - 1)) / 7.0);
        }
        NettyUtil.VAR_INT_BYTE_LENGTHS[32] = 1;
    }
}

