/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.driver.network.netty;

import com.google.common.base.Suppliers;
import io.netty5.channel.Channel;
import io.netty5.channel.ChannelFactory;
import io.netty5.channel.EventLoopGroup;
import io.netty5.channel.IoHandlerFactory;
import io.netty5.channel.MultithreadEventLoopGroup;
import io.netty5.channel.ServerChannel;
import io.netty5.channel.ServerChannelFactory;
import io.netty5.channel.epoll.Epoll;
import io.netty5.channel.epoll.EpollHandler;
import io.netty5.channel.epoll.EpollServerSocketChannel;
import io.netty5.channel.epoll.EpollSocketChannel;
import io.netty5.channel.kqueue.KQueue;
import io.netty5.channel.kqueue.KQueueHandler;
import io.netty5.channel.kqueue.KQueueServerSocketChannel;
import io.netty5.channel.kqueue.KQueueSocketChannel;
import io.netty5.channel.nio.NioHandler;
import io.netty5.channel.socket.nio.NioServerSocketChannel;
import io.netty5.channel.socket.nio.NioSocketChannel;
import java.util.function.Supplier;
import lombok.NonNull;

public enum NettyTransport {
    EPOLL("epoll", Epoll.isAvailable(), true, EpollHandler::newFactory, (ChannelFactory<? extends Channel>)((ChannelFactory)EpollSocketChannel::new), (ServerChannelFactory<? extends ServerChannel>)((ServerChannelFactory)EpollServerSocketChannel::new)),
    KQUEUE("kqueue", KQueue.isAvailable(), true, KQueueHandler::newFactory, (ChannelFactory<? extends Channel>)((ChannelFactory)KQueueSocketChannel::new), (ServerChannelFactory<? extends ServerChannel>)((ServerChannelFactory)KQueueServerSocketChannel::new)),
    NIO("nio", true, false, NioHandler::newFactory, (ChannelFactory<? extends Channel>)((ChannelFactory)NioSocketChannel::new), (ServerChannelFactory<? extends ServerChannel>)((ServerChannelFactory)NioServerSocketChannel::new));

    private final String name;
    private final boolean available;
    private final boolean nativeTransport;
    private final Supplier<IoHandlerFactory> ioHandlerFactory;
    private final ChannelFactory<? extends Channel> clientChannelFactory;
    private final ServerChannelFactory<? extends ServerChannel> serverChannelFactory;

    private NettyTransport(String name, @NonNull boolean available, @NonNull boolean nativeTransport, @NonNull Supplier<IoHandlerFactory> ioHandlerFactory, ChannelFactory<? extends Channel> clientChannelFactory, ServerChannelFactory<? extends ServerChannel> serverChannelFactory) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (ioHandlerFactory == null) {
            throw new NullPointerException("ioHandlerFactory is marked non-null but is null");
        }
        if (clientChannelFactory == null) {
            throw new NullPointerException("clientChannelFactory is marked non-null but is null");
        }
        if (serverChannelFactory == null) {
            throw new NullPointerException("serverChannelFactory is marked non-null but is null");
        }
        this.name = name;
        this.available = available;
        this.nativeTransport = nativeTransport;
        this.ioHandlerFactory = Suppliers.memoize(ioHandlerFactory::get);
        this.clientChannelFactory = clientChannelFactory;
        this.serverChannelFactory = serverChannelFactory;
    }

    @NonNull
    public static NettyTransport availableTransport(boolean noNative) {
        for (NettyTransport transport : NettyTransport.values()) {
            if (noNative && transport.nativeTransport() || !transport.available) continue;
            return transport;
        }
        throw new IllegalStateException("Unable to select an available netty transport!");
    }

    @NonNull
    public EventLoopGroup createEventLoopGroup(int threads) {
        return new MultithreadEventLoopGroup(threads, this.ioHandlerFactory.get());
    }

    @NonNull
    public String displayName() {
        return this.name;
    }

    public boolean nativeTransport() {
        return this.nativeTransport;
    }

    @NonNull
    public ChannelFactory<? extends Channel> clientChannelFactory() {
        return this.clientChannelFactory;
    }

    @NonNull
    public ServerChannelFactory<? extends ServerChannel> serverChannelFactory() {
        return this.serverChannelFactory;
    }
}

