/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.driver.network.netty;

import eu.cloudnetservice.driver.network.ssl.SSLConfiguration;
import io.netty5.handler.ssl.ClientAuth;
import io.netty5.handler.ssl.SslContext;
import io.netty5.handler.ssl.SslContextBuilder;
import io.netty5.handler.ssl.util.InsecureTrustManagerFactory;
import io.netty5.handler.ssl.util.SelfSignedCertificate;
import java.io.File;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public abstract class NettySslServer {
    protected final SSLConfiguration sslConfiguration;
    public SslContext sslContext;

    public NettySslServer(@Nullable SSLConfiguration sslConfiguration) {
        this.sslConfiguration = sslConfiguration;
    }

    protected void init() throws Exception {
        block22: {
            if (this.sslConfiguration != null && this.sslConfiguration.enabled()) {
                if (this.sslConfiguration.certificatePath() != null && this.sslConfiguration.privateKeyPath() != null) {
                    try (InputStream cert = Files.newInputStream(this.sslConfiguration.certificatePath(), new OpenOption[0]);
                         InputStream privateKey = Files.newInputStream(this.sslConfiguration.privateKeyPath(), new OpenOption[0]);){
                        SslContextBuilder builder = SslContextBuilder.forServer((InputStream)cert, (InputStream)privateKey);
                        if (this.sslConfiguration.trustCertificatePath() != null) {
                            try (InputStream stream = Files.newInputStream(this.sslConfiguration.trustCertificatePath(), new OpenOption[0]);){
                                builder.trustManager(stream);
                            }
                        } else {
                            builder.trustManager(InsecureTrustManagerFactory.INSTANCE);
                        }
                        this.sslContext = builder.clientAuth(this.sslConfiguration.clientAuth() ? ClientAuth.REQUIRE : ClientAuth.OPTIONAL).build();
                        break block22;
                    }
                }
                SelfSignedCertificate selfSignedCertificate = new SelfSignedCertificate();
                this.sslContext = SslContextBuilder.forServer((File)selfSignedCertificate.certificate(), (File)selfSignedCertificate.privateKey()).trustManager(InsecureTrustManagerFactory.INSTANCE).build();
            }
        }
    }
}

