/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.driver.network.netty;

import eu.cloudnetservice.driver.event.EventManager;
import eu.cloudnetservice.driver.event.events.network.NetworkChannelPacketSendEvent;
import eu.cloudnetservice.driver.network.DefaultNetworkChannel;
import eu.cloudnetservice.driver.network.HostAndPort;
import eu.cloudnetservice.driver.network.NetworkChannel;
import eu.cloudnetservice.driver.network.NetworkChannelHandler;
import eu.cloudnetservice.driver.network.netty.NettyUtil;
import eu.cloudnetservice.driver.network.protocol.Packet;
import eu.cloudnetservice.driver.network.protocol.PacketListenerRegistry;
import io.netty5.channel.Channel;
import io.netty5.util.concurrent.Future;
import lombok.NonNull;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class NettyNetworkChannel
extends DefaultNetworkChannel
implements NetworkChannel {
    private final Channel channel;
    private final EventManager eventManager;

    public NettyNetworkChannel(@NonNull Channel channel, @NonNull EventManager eventManager, @NonNull PacketListenerRegistry packetRegistry, @NonNull NetworkChannelHandler handler, @NonNull HostAndPort serverAddress, @NonNull HostAndPort clientAddress, boolean clientProvidedChannel) {
        super(packetRegistry, serverAddress, clientAddress, clientProvidedChannel, handler);
        if (channel == null) {
            throw new NullPointerException("channel is marked non-null but is null");
        }
        if (eventManager == null) {
            throw new NullPointerException("eventManager is marked non-null but is null");
        }
        if (packetRegistry == null) {
            throw new NullPointerException("packetRegistry is marked non-null but is null");
        }
        if (handler == null) {
            throw new NullPointerException("handler is marked non-null but is null");
        }
        if (serverAddress == null) {
            throw new NullPointerException("serverAddress is marked non-null but is null");
        }
        if (clientAddress == null) {
            throw new NullPointerException("clientAddress is marked non-null but is null");
        }
        this.channel = channel;
        this.eventManager = eventManager;
    }

    @Override
    public void sendPacket(Packet ... packets) {
        if (packets == null) {
            throw new NullPointerException("packets is marked non-null but is null");
        }
        for (Packet packet : packets) {
            this.writePacket(packet, false);
        }
        this.channel.flush();
    }

    @Override
    public void sendPacketSync(Packet ... packets) {
        if (packets == null) {
            throw new NullPointerException("packets is marked non-null but is null");
        }
        for (Packet packet : packets) {
            Future<Void> future = this.writePacket(packet, false);
            if (future == null) continue;
            NettyUtil.awaitFuture(future);
        }
        this.channel.flush();
    }

    @Override
    public void sendPacket(@NonNull Packet packet) {
        if (packet == null) {
            throw new NullPointerException("packet is marked non-null but is null");
        }
        if (this.channel.executor().inEventLoop()) {
            this.writePacket(packet, true);
        } else {
            this.channel.executor().execute(() -> this.writePacket(packet, true));
        }
    }

    @Override
    public void sendPacketSync(@NonNull Packet packet) {
        if (packet == null) {
            throw new NullPointerException("packet is marked non-null but is null");
        }
        Future<Void> future = this.writePacket(packet, true);
        if (future != null) {
            NettyUtil.awaitFuture(future);
        }
    }

    @Override
    public boolean writeable() {
        return this.channel.isWritable();
    }

    @Override
    public boolean active() {
        return this.channel.isActive();
    }

    @Override
    public void close() {
        this.channel.close();
    }

    @Nullable
    private Future<Void> writePacket(@NonNull Packet packet, boolean flushAfter) {
        if (packet == null) {
            throw new NullPointerException("packet is marked non-null but is null");
        }
        NetworkChannelPacketSendEvent event = this.eventManager.callEvent(new NetworkChannelPacketSendEvent(this, packet));
        if (!event.cancelled()) {
            return flushAfter ? this.channel.writeAndFlush((Object)packet) : this.channel.write((Object)packet);
        }
        return null;
    }
}

