/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.driver.network.http.annotation.parser;

import eu.cloudnetservice.common.util.StringUtil;
import eu.cloudnetservice.driver.network.http.HttpContext;
import eu.cloudnetservice.driver.network.http.HttpHandler;
import eu.cloudnetservice.driver.network.http.annotation.parser.AnnotationHttpHandleException;
import eu.cloudnetservice.driver.network.http.annotation.parser.ParameterInvocationHint;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Method;
import java.util.Collection;
import lombok.NonNull;

final class MethodHttpHandlerInvoker
extends HttpHandler {
    private final Object instance;
    private final MethodHandle handlerMethod;
    private final Class<?>[] handlerParameterTypes;
    private final Collection<String> supportedMethods;

    public MethodHttpHandlerInvoker(@NonNull Object handlerInstance, @NonNull Method handlerMethod, @NonNull Collection<String> supportedMethods) throws IllegalAccessException {
        if (handlerInstance == null) {
            throw new NullPointerException("handlerInstance is marked non-null but is null");
        }
        if (handlerMethod == null) {
            throw new NullPointerException("handlerMethod is marked non-null but is null");
        }
        if (supportedMethods == null) {
            throw new NullPointerException("supportedMethods is marked non-null but is null");
        }
        this.instance = handlerInstance;
        this.handlerMethod = MethodHttpHandlerInvoker.genericHandleForMethod(handlerMethod);
        this.handlerParameterTypes = handlerMethod.getParameterTypes();
        this.supportedMethods = supportedMethods;
    }

    @NonNull
    private static MethodHandle genericHandleForMethod(@NonNull Method method) throws IllegalAccessException {
        if (method == null) {
            throw new NullPointerException("method is marked non-null but is null");
        }
        MethodType methodType = MethodType.genericMethodType(1, true);
        return MethodHandles.lookup().unreflect(method).asFixedArity().asSpreader(1, Object[].class, method.getParameterCount()).asType(methodType);
    }

    @Override
    public void handle(@NonNull String path, @NonNull HttpContext context) throws Throwable {
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        if (this.supportedMethods.contains(StringUtil.toUpper((String)context.request().method()))) {
            Object[] arguments = this.buildInvocationArguments(path, context);
            this.handlerMethod.invoke(this.instance, arguments);
        }
    }

    @NonNull
    private Object[] buildInvocationArguments(@NonNull String path, @NonNull HttpContext context) {
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        Object[] arguments = new Object[this.handlerParameterTypes.length];
        Collection<Object> invocationHints = context.invocationHints("__PARAM_INVOCATION_HINT__");
        int expectedArgumentCount = arguments.length - 1;
        if (invocationHints.size() != expectedArgumentCount) {
            throw new AnnotationHttpHandleException(path, String.format("Arguments count to call handler does not match (got: %d; expected: %d)", invocationHints.size(), expectedArgumentCount));
        }
        for (Object invocationHint : invocationHints) {
            if (invocationHint instanceof ParameterInvocationHint) {
                ParameterInvocationHint hint = (ParameterInvocationHint)invocationHint;
                if (hint.index() <= 0 || hint.index() >= arguments.length) {
                    throw new AnnotationHttpHandleException(path, "Invocation hint index " + hint.index() + " is out of bounds");
                }
                Object value = hint.resolveValue(path, context);
                Class<?> expectedType = this.handlerParameterTypes[hint.index()];
                if (value != null && !expectedType.isAssignableFrom(value.getClass())) {
                    throw new AnnotationHttpHandleException(path, String.format("Parameter at index %d is of type %s; expected type %s", hint.index(), value.getClass().getName(), expectedType.getName()));
                }
                if (value == null && expectedType.isPrimitive()) {
                    throw new AnnotationHttpHandleException(path, String.format("Parameter at index %d is primitive but null was resolved as the parameter value", hint.index()));
                }
                arguments[hint.index()] = value;
                continue;
            }
            throw new AnnotationHttpHandleException(path, "Hint " + invocationHint + " is not an ParameterInvocationHint");
        }
        arguments[0] = context;
        return arguments;
    }
}

