/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.driver.network.http;

import eu.cloudnetservice.driver.network.http.HttpContext;
import eu.cloudnetservice.driver.network.http.HttpContextPreprocessor;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.LinkedList;
import lombok.NonNull;
import org.jetbrains.annotations.UnmodifiableView;

public abstract class HttpHandler {
    public static final int PRIORITY_HIGH = 64;
    public static final int PRIORITY_NORMAL = 32;
    public static final int PRIORITY_LOW = 16;
    public static final int PRIORITY_LOWEST = 0;
    private final Deque<HttpContextPreprocessor> preprocessors = new LinkedList<HttpContextPreprocessor>();

    @NonNull
    public HttpHandler addPreProcessorHead(@NonNull HttpContextPreprocessor preprocessor) {
        if (preprocessor == null) {
            throw new NullPointerException("preprocessor is marked non-null but is null");
        }
        this.preprocessors.addFirst(preprocessor);
        return this;
    }

    @NonNull
    public HttpHandler addPreProcessorTail(@NonNull HttpContextPreprocessor preprocessor) {
        if (preprocessor == null) {
            throw new NullPointerException("preprocessor is marked non-null but is null");
        }
        this.preprocessors.addLast(preprocessor);
        return this;
    }

    public @UnmodifiableView @NonNull Collection<HttpContextPreprocessor> preprocessors() {
        return Collections.unmodifiableCollection(this.preprocessors);
    }

    public abstract void handle(@NonNull String var1, @NonNull HttpContext var2) throws Throwable;
}

