/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.driver.network.chunk.network;

import eu.cloudnetservice.driver.network.NetworkChannel;
import eu.cloudnetservice.driver.network.chunk.ChunkedPacketHandler;
import eu.cloudnetservice.driver.network.chunk.data.ChunkSessionInformation;
import eu.cloudnetservice.driver.network.protocol.Packet;
import eu.cloudnetservice.driver.network.protocol.PacketListener;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import lombok.NonNull;

public class ChunkedPacketListener
implements PacketListener {
    private final Function<ChunkSessionInformation, ChunkedPacketHandler> handlerFactory;
    private final Map<ChunkSessionInformation, ChunkedPacketHandler> runningSessions = new ConcurrentHashMap<ChunkSessionInformation, ChunkedPacketHandler>();

    public ChunkedPacketListener(@NonNull Function<ChunkSessionInformation, ChunkedPacketHandler> handlerFactory) {
        if (handlerFactory == null) {
            throw new NullPointerException("handlerFactory is marked non-null but is null");
        }
        this.handlerFactory = handlerFactory;
    }

    @Override
    public void handle(@NonNull NetworkChannel channel, @NonNull Packet packet) throws Exception {
        if (channel == null) {
            throw new NullPointerException("channel is marked non-null but is null");
        }
        if (packet == null) {
            throw new NullPointerException("packet is marked non-null but is null");
        }
        ChunkSessionInformation information = packet.content().readObject(ChunkSessionInformation.class);
        int chunkIndex = packet.content().readInt();
        ChunkedPacketHandler handler = this.runningSessions.computeIfAbsent(information, this.handlerFactory);
        if (handler.handleChunkPart(chunkIndex, packet.content())) {
            this.runningSessions.remove(information);
        }
    }
}

