/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.driver.network.chunk.defaults.factory;

import eu.cloudnetservice.driver.event.EventManager;
import eu.cloudnetservice.driver.event.events.chunk.ChunkedPacketSessionOpenEvent;
import eu.cloudnetservice.driver.network.chunk.ChunkedPacketHandler;
import eu.cloudnetservice.driver.network.chunk.data.ChunkSessionInformation;
import java.util.function.Function;
import lombok.NonNull;

public class EventChunkHandlerFactory
implements Function<ChunkSessionInformation, ChunkedPacketHandler> {
    private final EventManager eventManager;

    protected EventChunkHandlerFactory(@NonNull EventManager eventManager) {
        if (eventManager == null) {
            throw new NullPointerException("eventManager is marked non-null but is null");
        }
        this.eventManager = eventManager;
    }

    @NonNull
    public static EventChunkHandlerFactory withEventManager(@NonNull EventManager manager) {
        if (manager == null) {
            throw new NullPointerException("manager is marked non-null but is null");
        }
        return new EventChunkHandlerFactory(manager);
    }

    @Override
    @NonNull
    public ChunkedPacketHandler apply(@NonNull ChunkSessionInformation info) {
        if (info == null) {
            throw new NullPointerException("info is marked non-null but is null");
        }
        ChunkedPacketHandler handler = this.eventManager.callEvent(new ChunkedPacketSessionOpenEvent(info)).handler();
        if (handler == null) {
            throw new IllegalStateException("No chunked handler for " + info);
        }
        return handler;
    }
}

