/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.driver.network.chunk.defaults.builder;

import com.google.common.base.Preconditions;
import eu.cloudnetservice.driver.network.NetworkChannel;
import eu.cloudnetservice.driver.network.buffer.DataBuf;
import eu.cloudnetservice.driver.network.chunk.ChunkedPacketSender;
import eu.cloudnetservice.driver.network.chunk.defaults.splitter.NetworkChannelsPacketSplitter;
import eu.cloudnetservice.driver.network.protocol.Packet;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.UUID;
import java.util.function.Consumer;
import lombok.NonNull;

public abstract class DefaultChunkedPacketSenderBuilder
implements ChunkedPacketSender.Builder {
    public static final int DEFAULT_CHUNK_SIZE = 0x3200000;
    protected InputStream source;
    protected String transferChannel;
    protected Consumer<Packet> packetSplitter;
    protected int chunkSize = 0x3200000;
    protected UUID sessionUniqueId = UUID.randomUUID();
    protected DataBuf transferInformation = DataBuf.empty();

    @Override
    @NonNull
    public ChunkedPacketSender.Builder chunkSize(int chunkSize) {
        this.chunkSize = chunkSize;
        return this;
    }

    @Override
    @NonNull
    public ChunkedPacketSender.Builder sessionUniqueId(@NonNull UUID uuid) {
        if (uuid == null) {
            throw new NullPointerException("uuid is marked non-null but is null");
        }
        this.sessionUniqueId = uuid;
        return this;
    }

    @Override
    @NonNull
    public ChunkedPacketSender.Builder transferChannel(@NonNull String transferChannel) {
        if (transferChannel == null) {
            throw new NullPointerException("transferChannel is marked non-null but is null");
        }
        this.transferChannel = transferChannel;
        return this;
    }

    @Override
    @NonNull
    public ChunkedPacketSender.Builder source(@NonNull InputStream source) {
        if (source == null) {
            throw new NullPointerException("source is marked non-null but is null");
        }
        this.source = source;
        return this;
    }

    @Override
    @NonNull
    public ChunkedPacketSender.Builder toChannels(NetworkChannel ... channels) {
        if (channels == null) {
            throw new NullPointerException("channels is marked non-null but is null");
        }
        return this.toChannels(Arrays.asList(channels));
    }

    @Override
    @NonNull
    public ChunkedPacketSender.Builder toChannels(@NonNull Collection<NetworkChannel> channels) {
        if (channels == null) {
            throw new NullPointerException("channels is marked non-null but is null");
        }
        return this.packetSplitter(new NetworkChannelsPacketSplitter(channels));
    }

    @Override
    @NonNull
    public ChunkedPacketSender.Builder packetSplitter(@NonNull Consumer<Packet> splitter) {
        if (splitter == null) {
            throw new NullPointerException("splitter is marked non-null but is null");
        }
        this.packetSplitter = splitter;
        return this;
    }

    @Override
    @NonNull
    public ChunkedPacketSender.Builder withExtraData(@NonNull DataBuf extraData) {
        if (extraData == null) {
            throw new NullPointerException("extraData is marked non-null but is null");
        }
        this.transferInformation.release();
        this.transferInformation = extraData;
        return this;
    }

    @Override
    @NonNull
    public ChunkedPacketSender build() {
        Preconditions.checkNotNull((Object)this.source, (Object)"no source given to send");
        Preconditions.checkNotNull(this.packetSplitter, (Object)"no packet splitter provided");
        Preconditions.checkNotNull((Object)this.transferChannel, (Object)"no transfer channel provided");
        Preconditions.checkNotNull((Object)this.sessionUniqueId, (Object)"no session unique id provided");
        Preconditions.checkArgument((this.chunkSize > 0 ? 1 : 0) != 0, (Object)"chunk size must be more than 0");
        return this.doBuild();
    }

    @NonNull
    protected abstract ChunkedPacketSender doBuild();
}

