/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.driver.network.chunk.defaults;

import eu.cloudnetservice.common.concurrent.Task;
import eu.cloudnetservice.driver.network.chunk.ChunkedPacketSender;
import eu.cloudnetservice.driver.network.chunk.TransferStatus;
import eu.cloudnetservice.driver.network.chunk.data.ChunkSessionInformation;
import eu.cloudnetservice.driver.network.chunk.defaults.DefaultChunkedPacketProvider;
import eu.cloudnetservice.driver.network.chunk.network.ChunkedPacket;
import eu.cloudnetservice.driver.network.protocol.Packet;
import java.io.InputStream;
import java.util.function.Consumer;
import lombok.NonNull;

public class DefaultFileChunkPacketSender
extends DefaultChunkedPacketProvider
implements ChunkedPacketSender {
    protected static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    protected final InputStream source;
    protected final Consumer<Packet> packetSplitter;

    public DefaultFileChunkPacketSender(@NonNull ChunkSessionInformation sessionInformation, @NonNull InputStream source, @NonNull Consumer<Packet> packetSplitter) {
        super(sessionInformation);
        if (sessionInformation == null) {
            throw new NullPointerException("sessionInformation is marked non-null but is null");
        }
        if (source == null) {
            throw new NullPointerException("source is marked non-null but is null");
        }
        if (packetSplitter == null) {
            throw new NullPointerException("packetSplitter is marked non-null but is null");
        }
        this.source = source;
        this.packetSplitter = packetSplitter;
    }

    @Override
    @NonNull
    public InputStream source() {
        return this.source;
    }

    @Override
    @NonNull
    public Consumer<Packet> packetSplitter() {
        return this.packetSplitter;
    }

    @Override
    @NonNull
    public Task<TransferStatus> transferChunkedData() {
        return Task.supply(() -> {
            int bytesRead;
            int readCalls = 0;
            byte[] backingArray = new byte[this.chunkSessionInformation.chunkSize()];
            while ((bytesRead = this.source.read(backingArray)) != -1 && bytesRead == backingArray.length) {
                this.chunkSessionInformation.transferInformation().acquire();
                this.packetSplitter.accept(ChunkedPacket.createChunk(this.chunkSessionInformation, readCalls++, backingArray));
            }
            this.packetSplitter.accept(ChunkedPacket.createChunk(this.chunkSessionInformation, readCalls, readCalls, bytesRead == -1 ? 0 : bytesRead, bytesRead == -1 ? EMPTY_BYTE_ARRAY : backingArray));
            this.source.close();
            this.chunkSessionInformation.transferInformation().release();
            return TransferStatus.SUCCESS;
        });
    }
}

