/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.driver.network.buffer;

import eu.cloudnetservice.driver.network.buffer.DataBufFactory;
import java.lang.reflect.Type;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.Function;
import lombok.NonNull;
import org.jetbrains.annotations.Nullable;

public interface DataBuf
extends AutoCloseable {
    @NonNull
    public static Mutable empty() {
        return DataBufFactory.defaultFactory().createEmpty();
    }

    public boolean readBoolean();

    public byte readByte();

    public int readInt();

    public short readShort();

    public long readLong();

    public float readFloat();

    public double readDouble();

    public char readChar();

    public byte[] readByteArray();

    @NonNull
    public UUID readUniqueId();

    @NonNull
    public String readString();

    @NonNull
    public DataBuf readDataBuf();

    public byte[] toByteArray();

    public <T> T readObject(@NonNull Class<T> var1);

    public <T> T readObject(@NonNull Type var1);

    @Nullable
    public <T> T readNullable(@NonNull Function<DataBuf, T> var1);

    public <T> T readNullable(@NonNull Function<DataBuf, T> var1, @Nullable T var2);

    public int readableBytes();

    @NonNull
    public DataBuf startTransaction();

    @NonNull
    public DataBuf redoTransaction();

    @NonNull
    public Mutable asMutable();

    public boolean accessible();

    public int acquires();

    @NonNull
    public DataBuf acquire();

    public void release();

    public void forceRelease();

    @Override
    public void close();

    public static interface Mutable
    extends DataBuf {
        @NonNull
        public Mutable writeBoolean(boolean var1);

        @NonNull
        public Mutable writeInt(int var1);

        @NonNull
        public Mutable writeByte(byte var1);

        @NonNull
        public Mutable writeShort(short var1);

        @NonNull
        public Mutable writeLong(long var1);

        @NonNull
        public Mutable writeFloat(float var1);

        @NonNull
        public Mutable writeDouble(double var1);

        @NonNull
        public Mutable writeChar(char var1);

        @NonNull
        public Mutable writeByteArray(byte[] var1);

        @NonNull
        public Mutable writeByteArray(byte[] var1, int var2);

        @NonNull
        public Mutable writeUniqueId(@NonNull UUID var1);

        @NonNull
        public Mutable writeString(@NonNull String var1);

        @NonNull
        public Mutable writeDataBuf(@NonNull DataBuf var1);

        @NonNull
        public Mutable writeObject(@Nullable Object var1);

        @NonNull
        public <T> Mutable writeNullable(@Nullable T var1, @NonNull BiConsumer<Mutable, T> var2);

        @NonNull
        public DataBuf asImmutable();
    }
}

