/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.driver.network;

import com.google.common.collect.Iterables;
import eu.cloudnetservice.driver.network.NetworkChannel;
import eu.cloudnetservice.driver.network.protocol.PacketListenerRegistry;
import eu.cloudnetservice.driver.network.protocol.PacketSender;
import java.util.Collection;
import java.util.concurrent.Executor;
import lombok.NonNull;
import org.jetbrains.annotations.UnknownNullability;
import org.jetbrains.annotations.Unmodifiable;

public interface NetworkComponent
extends PacketSender {
    public boolean sslEnabled();

    @NonNull
    public @Unmodifiable Collection<NetworkChannel> channels();

    default public @UnknownNullability NetworkChannel firstChannel() {
        return (NetworkChannel)Iterables.getFirst(this.channels(), null);
    }

    @NonNull
    public Executor packetDispatcher();

    @NonNull
    public PacketListenerRegistry packetRegistry();

    public void closeChannels();
}

