/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.driver.network;

import com.google.common.base.Preconditions;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.UnixDomainSocketAddress;
import lombok.NonNull;
import org.jetbrains.annotations.Contract;

public record HostAndPort(@NonNull String host, int port) {
    public static final int NO_PORT = -1;

    public HostAndPort(@NonNull String host, int port) {
        if (host == null) {
            throw new NullPointerException("host is marked non-null but is null");
        }
        Preconditions.checkArgument((this.port() >= -1 && this.port() <= 65535 ? 1 : 0) != 0, (Object)"invalid port given");
        this.host = host;
        this.port = port;
    }

    @Contract(value="_ -> new")
    @NonNull
    public static HostAndPort fromSocketAddress(@NonNull SocketAddress socketAddress) {
        if (socketAddress == null) {
            throw new NullPointerException("socketAddress is marked non-null but is null");
        }
        if (socketAddress instanceof InetSocketAddress) {
            InetSocketAddress inet = (InetSocketAddress)socketAddress;
            return new HostAndPort(inet.getAddress().getHostAddress(), inet.getPort());
        }
        if (socketAddress instanceof UnixDomainSocketAddress) {
            UnixDomainSocketAddress unix = (UnixDomainSocketAddress)socketAddress;
            return new HostAndPort(unix.getPath().toString(), -1);
        }
        throw new IllegalArgumentException("Unsupported socket address type: " + socketAddress.getClass().getName());
    }

    public boolean validPort() {
        return this.port != -1;
    }

    @Override
    @NonNull
    public String toString() {
        return this.host + ":" + this.port;
    }
}

