/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.driver.network;

import eu.cloudnetservice.common.log.LogManager;
import eu.cloudnetservice.common.log.Logger;
import eu.cloudnetservice.driver.network.NetworkChannel;
import eu.cloudnetservice.driver.network.NetworkComponent;
import eu.cloudnetservice.driver.network.protocol.Packet;
import java.util.Collection;
import java.util.Iterator;
import lombok.NonNull;
import org.jetbrains.annotations.ApiStatus;

public interface DefaultNetworkComponent
extends NetworkComponent {
    public static final Logger LOGGER = LogManager.logger(DefaultNetworkComponent.class);

    @ApiStatus.Internal
    @NonNull
    public Collection<NetworkChannel> modifiableChannels();

    @Override
    default public void closeChannels() {
        Iterator<NetworkChannel> iterator = this.modifiableChannels().iterator();
        while (iterator.hasNext()) {
            iterator.next().close();
            iterator.remove();
        }
    }

    @Override
    default public void sendPacket(@NonNull Packet packet) {
        if (packet == null) {
            throw new NullPointerException("packet is marked non-null but is null");
        }
        for (NetworkChannel channel : this.modifiableChannels()) {
            channel.sendPacket(packet);
        }
    }

    @Override
    default public void sendPacketSync(@NonNull Packet packet) {
        if (packet == null) {
            throw new NullPointerException("packet is marked non-null but is null");
        }
        for (NetworkChannel channel : this.modifiableChannels()) {
            channel.sendPacketSync(packet);
        }
    }

    @Override
    default public void sendPacket(Packet ... packets) {
        if (packets == null) {
            throw new NullPointerException("packets is marked non-null but is null");
        }
        for (NetworkChannel channel : this.modifiableChannels()) {
            channel.sendPacket(packets);
        }
    }
}

