/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.driver.network;

import eu.cloudnetservice.common.concurrent.Task;
import eu.cloudnetservice.driver.network.HostAndPort;
import eu.cloudnetservice.driver.network.NetworkChannel;
import eu.cloudnetservice.driver.network.NetworkChannelHandler;
import eu.cloudnetservice.driver.network.protocol.Packet;
import eu.cloudnetservice.driver.network.protocol.PacketListenerRegistry;
import eu.cloudnetservice.driver.network.protocol.QueryPacketManager;
import eu.cloudnetservice.driver.network.protocol.defaults.DefaultPacketListenerRegistry;
import eu.cloudnetservice.driver.network.protocol.defaults.DefaultQueryPacketManager;
import java.util.concurrent.atomic.AtomicLong;
import lombok.NonNull;

public abstract class DefaultNetworkChannel
implements NetworkChannel {
    private static final AtomicLong CHANNEL_ID_COUNTER = new AtomicLong();
    private final long channelId = CHANNEL_ID_COUNTER.incrementAndGet();
    private final QueryPacketManager queryPacketManager;
    private final PacketListenerRegistry packetRegistry;
    private final HostAndPort serverAddress;
    private final HostAndPort clientAddress;
    private final boolean clientProvidedChannel;
    private final NetworkChannelHandler handler;

    public DefaultNetworkChannel(@NonNull PacketListenerRegistry packetRegistry, @NonNull HostAndPort serverAddress, @NonNull HostAndPort clientAddress, boolean clientProvidedChannel, @NonNull NetworkChannelHandler handler) {
        if (packetRegistry == null) {
            throw new NullPointerException("packetRegistry is marked non-null but is null");
        }
        if (serverAddress == null) {
            throw new NullPointerException("serverAddress is marked non-null but is null");
        }
        if (clientAddress == null) {
            throw new NullPointerException("clientAddress is marked non-null but is null");
        }
        if (handler == null) {
            throw new NullPointerException("handler is marked non-null but is null");
        }
        this.queryPacketManager = new DefaultQueryPacketManager(this);
        this.packetRegistry = new DefaultPacketListenerRegistry(packetRegistry);
        this.serverAddress = serverAddress;
        this.clientAddress = clientAddress;
        this.clientProvidedChannel = clientProvidedChannel;
        this.handler = handler;
    }

    @Override
    @NonNull
    public Task<Packet> sendQueryAsync(@NonNull Packet packet) {
        if (packet == null) {
            throw new NullPointerException("packet is marked non-null but is null");
        }
        return this.queryPacketManager.sendQueryPacket(packet);
    }

    @Override
    public Packet sendQuery(@NonNull Packet packet) {
        if (packet == null) {
            throw new NullPointerException("packet is marked non-null but is null");
        }
        return (Packet)this.sendQueryAsync(packet).getOrNull();
    }

    @Override
    public long channelId() {
        return this.channelId;
    }

    @Override
    @NonNull
    public PacketListenerRegistry packetRegistry() {
        return this.packetRegistry;
    }

    @Override
    @NonNull
    public QueryPacketManager queryPacketManager() {
        return this.queryPacketManager;
    }

    @Override
    @NonNull
    public HostAndPort serverAddress() {
        return this.serverAddress;
    }

    @Override
    @NonNull
    public HostAndPort clientAddress() {
        return this.clientAddress;
    }

    @Override
    public boolean clientProvidedChannel() {
        return this.clientProvidedChannel;
    }

    @Override
    @NonNull
    public NetworkChannelHandler handler() {
        return this.handler;
    }
}

