/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.driver.module;

import com.google.common.base.Preconditions;
import eu.cloudnetservice.common.Named;
import lombok.NonNull;
import org.jetbrains.annotations.ApiStatus;

public class ModuleRepository
implements Named {
    private String name;
    private String url;

    public ModuleRepository(@NonNull String name, @NonNull String url) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (url == null) {
            throw new NullPointerException("url is marked non-null but is null");
        }
        this.name = name;
        this.url = url;
    }

    @ApiStatus.Internal
    public ModuleRepository() {
    }

    @NonNull
    public String name() {
        return this.name;
    }

    @NonNull
    public String url() {
        return this.url;
    }

    public void assertComplete() {
        Preconditions.checkNotNull((Object)this.name, (Object)"Missing repository name");
        Preconditions.checkNotNull((Object)this.url, (Object)"Missing repository url");
    }

    public String toString() {
        return "ModuleRepository(name=" + this.name + ", url=" + this.url + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ModuleRepository)) {
            return false;
        }
        ModuleRepository other = (ModuleRepository)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$name = this.name;
        String other$name = other.name;
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$url = this.url;
        String other$url = other.url;
        return !(this$url == null ? other$url != null : !this$url.equals(other$url));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ModuleRepository;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.name;
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $url = this.url;
        result = result * 59 + ($url == null ? 43 : $url.hashCode());
        return result;
    }
}

