/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.driver.module;

import java.util.Arrays;
import lombok.NonNull;

public enum ModuleLifeCycle {
    CREATED(1),
    LOADED(2),
    STARTED(3, 4),
    RELOADING(2),
    STOPPED(2, 5),
    UNLOADED(1, 6),
    UNUSABLE(new int[0]);

    private final int[] possibleChangeTargetOrdinals;

    private ModuleLifeCycle(int ... possibleChangeTargetOrdinals) {
        this.possibleChangeTargetOrdinals = possibleChangeTargetOrdinals;
        Arrays.sort(this.possibleChangeTargetOrdinals);
    }

    public boolean canChangeTo(@NonNull ModuleLifeCycle target) {
        if (target == null) {
            throw new NullPointerException("target is marked non-null but is null");
        }
        return Arrays.binarySearch(this.possibleChangeTargetOrdinals, target.ordinal()) >= 0;
    }
}

