/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.driver.module;

import eu.cloudnetservice.common.language.I18n;
import eu.cloudnetservice.common.log.LogManager;
import eu.cloudnetservice.common.log.Logger;
import eu.cloudnetservice.driver.event.Event;
import eu.cloudnetservice.driver.event.EventManager;
import eu.cloudnetservice.driver.event.events.module.ModulePostInstallDependencyEvent;
import eu.cloudnetservice.driver.event.events.module.ModulePostLoadEvent;
import eu.cloudnetservice.driver.event.events.module.ModulePostReloadEvent;
import eu.cloudnetservice.driver.event.events.module.ModulePostStartEvent;
import eu.cloudnetservice.driver.event.events.module.ModulePostStopEvent;
import eu.cloudnetservice.driver.event.events.module.ModulePostUnloadEvent;
import eu.cloudnetservice.driver.event.events.module.ModulePreInstallDependencyEvent;
import eu.cloudnetservice.driver.event.events.module.ModulePreLoadEvent;
import eu.cloudnetservice.driver.event.events.module.ModulePreReloadEvent;
import eu.cloudnetservice.driver.event.events.module.ModulePreStartEvent;
import eu.cloudnetservice.driver.event.events.module.ModulePreStopEvent;
import eu.cloudnetservice.driver.event.events.module.ModulePreUnloadEvent;
import eu.cloudnetservice.driver.module.ModuleConfiguration;
import eu.cloudnetservice.driver.module.ModuleDependency;
import eu.cloudnetservice.driver.module.ModuleProvider;
import eu.cloudnetservice.driver.module.ModuleProviderHandler;
import eu.cloudnetservice.driver.module.ModuleWrapper;
import eu.cloudnetservice.driver.registry.ServiceRegistry;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import lombok.NonNull;

@Singleton
public class DefaultModuleProviderHandler
implements ModuleProviderHandler {
    private static final Logger LOGGER = LogManager.logger(DefaultModuleProviderHandler.class);
    protected final EventManager eventManager;
    protected final ModuleProvider moduleProvider;
    protected final ServiceRegistry serviceRegistry;

    @Inject
    protected DefaultModuleProviderHandler(@NonNull EventManager eventManager, @NonNull ModuleProvider moduleProvider, @NonNull ServiceRegistry serviceRegistry) {
        if (eventManager == null) {
            throw new NullPointerException("eventManager is marked non-null but is null");
        }
        if (moduleProvider == null) {
            throw new NullPointerException("moduleProvider is marked non-null but is null");
        }
        if (serviceRegistry == null) {
            throw new NullPointerException("serviceRegistry is marked non-null but is null");
        }
        this.eventManager = eventManager;
        this.moduleProvider = moduleProvider;
        this.serviceRegistry = serviceRegistry;
    }

    @Override
    public boolean handlePreModuleLoad(@NonNull ModuleWrapper moduleWrapper) {
        if (moduleWrapper == null) {
            throw new NullPointerException("moduleWrapper is marked non-null but is null");
        }
        return !this.callEvent(new ModulePreLoadEvent(this.moduleProvider, moduleWrapper)).cancelled();
    }

    @Override
    public void handlePostModuleLoad(@NonNull ModuleWrapper moduleWrapper) {
        if (moduleWrapper == null) {
            throw new NullPointerException("moduleWrapper is marked non-null but is null");
        }
        this.callEvent(new ModulePostLoadEvent(this.moduleProvider, moduleWrapper));
        LOGGER.info(I18n.trans((String)"cloudnet-post-load-module", (Object[])this.moduleArguments(moduleWrapper.moduleConfiguration())));
    }

    @Override
    public boolean handlePreModuleStart(@NonNull ModuleWrapper moduleWrapper) {
        if (moduleWrapper == null) {
            throw new NullPointerException("moduleWrapper is marked non-null but is null");
        }
        boolean cancelled = this.callEvent(new ModulePreStartEvent(this.moduleProvider, moduleWrapper)).cancelled();
        if (!cancelled) {
            this.eventManager.registerListener(moduleWrapper.module());
        }
        return !cancelled;
    }

    @Override
    public void handlePostModuleStart(@NonNull ModuleWrapper moduleWrapper) {
        if (moduleWrapper == null) {
            throw new NullPointerException("moduleWrapper is marked non-null but is null");
        }
        this.callEvent(new ModulePostStartEvent(this.moduleProvider, moduleWrapper));
        LOGGER.info(I18n.trans((String)"cloudnet-post-start-module", (Object[])this.moduleArguments(moduleWrapper.moduleConfiguration())));
    }

    @Override
    public boolean handlePreModuleReload(@NonNull ModuleWrapper moduleWrapper) {
        if (moduleWrapper == null) {
            throw new NullPointerException("moduleWrapper is marked non-null but is null");
        }
        return !this.callEvent(new ModulePreReloadEvent(this.moduleProvider, moduleWrapper)).cancelled();
    }

    @Override
    public void handlePostModuleReload(@NonNull ModuleWrapper moduleWrapper) {
        if (moduleWrapper == null) {
            throw new NullPointerException("moduleWrapper is marked non-null but is null");
        }
        this.callEvent(new ModulePostReloadEvent(this.moduleProvider, moduleWrapper));
        LOGGER.info(I18n.trans((String)"cloudnet-post-reload-module", (Object[])this.moduleArguments(moduleWrapper.moduleConfiguration())));
    }

    @Override
    public boolean handlePreModuleStop(@NonNull ModuleWrapper moduleWrapper) {
        if (moduleWrapper == null) {
            throw new NullPointerException("moduleWrapper is marked non-null but is null");
        }
        return !this.callEvent(new ModulePreStopEvent(this.moduleProvider, moduleWrapper)).cancelled();
    }

    @Override
    public void handlePostModuleStop(@NonNull ModuleWrapper moduleWrapper) {
        if (moduleWrapper == null) {
            throw new NullPointerException("moduleWrapper is marked non-null but is null");
        }
        this.serviceRegistry.unregisterAll(moduleWrapper.classLoader());
        this.eventManager.unregisterListeners(moduleWrapper.classLoader());
        this.callEvent(new ModulePostStopEvent(this.moduleProvider, moduleWrapper));
        LOGGER.info(I18n.trans((String)"cloudnet-post-stop-module", (Object[])this.moduleArguments(moduleWrapper.moduleConfiguration())));
    }

    @Override
    public void handlePreModuleUnload(@NonNull ModuleWrapper moduleWrapper) {
        if (moduleWrapper == null) {
            throw new NullPointerException("moduleWrapper is marked non-null but is null");
        }
        this.callEvent(new ModulePreUnloadEvent(this.moduleProvider, moduleWrapper));
    }

    @Override
    public void handlePostModuleUnload(@NonNull ModuleWrapper moduleWrapper) {
        if (moduleWrapper == null) {
            throw new NullPointerException("moduleWrapper is marked non-null but is null");
        }
        this.callEvent(new ModulePostUnloadEvent(this.moduleProvider, moduleWrapper));
        LOGGER.info(I18n.trans((String)"cloudnet-post-unload-module", (Object[])this.moduleArguments(moduleWrapper.moduleConfiguration())));
    }

    @Override
    public void handlePreInstallDependency(@NonNull ModuleConfiguration configuration, @NonNull ModuleDependency dependency) {
        if (configuration == null) {
            throw new NullPointerException("configuration is marked non-null but is null");
        }
        if (dependency == null) {
            throw new NullPointerException("dependency is marked non-null but is null");
        }
        this.callEvent(new ModulePreInstallDependencyEvent(this.moduleProvider, configuration, dependency));
    }

    @Override
    public void handlePostInstallDependency(@NonNull ModuleConfiguration configuration, @NonNull ModuleDependency dependency) {
        if (configuration == null) {
            throw new NullPointerException("configuration is marked non-null but is null");
        }
        if (dependency == null) {
            throw new NullPointerException("dependency is marked non-null but is null");
        }
        this.callEvent(new ModulePostInstallDependencyEvent(this.moduleProvider, configuration, dependency));
        LOGGER.fine(I18n.trans((String)"cloudnet-post-install-dependency-module", (Object[])new Object[]{this.moduleArguments(configuration), dependency.group(), dependency.name(), dependency.version()}));
    }

    @NonNull
    protected <T extends Event> T callEvent(@NonNull T event) {
        if (event == null) {
            throw new NullPointerException("event is marked non-null but is null");
        }
        return this.eventManager.callEvent(event);
    }

    protected Object[] moduleArguments(@NonNull ModuleConfiguration configuration) {
        if (configuration == null) {
            throw new NullPointerException("configuration is marked non-null but is null");
        }
        return new String[]{configuration.group(), configuration.name(), configuration.version()};
    }
}

