/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.driver.module;

import com.google.common.base.Preconditions;
import dev.derklaro.aerogel.Element;
import dev.derklaro.aerogel.Injector;
import dev.derklaro.aerogel.SpecifiedInjector;
import dev.derklaro.aerogel.auto.Provides;
import dev.derklaro.aerogel.binding.BindingBuilder;
import dev.derklaro.aerogel.util.Qualifiers;
import eu.cloudnetservice.common.io.FileUtil;
import eu.cloudnetservice.common.jvm.JavaVersion;
import eu.cloudnetservice.common.log.LogManager;
import eu.cloudnetservice.common.log.Logger;
import eu.cloudnetservice.common.tuple.Tuple2;
import eu.cloudnetservice.driver.document.Document;
import eu.cloudnetservice.driver.document.DocumentFactory;
import eu.cloudnetservice.driver.inject.InjectionLayer;
import eu.cloudnetservice.driver.module.DefaultModuleDependencyLoader;
import eu.cloudnetservice.driver.module.DefaultModuleWrapper;
import eu.cloudnetservice.driver.module.Module;
import eu.cloudnetservice.driver.module.ModuleConfiguration;
import eu.cloudnetservice.driver.module.ModuleConfigurationNotFoundException;
import eu.cloudnetservice.driver.module.ModuleDependency;
import eu.cloudnetservice.driver.module.ModuleDependencyLoader;
import eu.cloudnetservice.driver.module.ModuleLifeCycle;
import eu.cloudnetservice.driver.module.ModuleProvider;
import eu.cloudnetservice.driver.module.ModuleProviderHandler;
import eu.cloudnetservice.driver.module.ModuleRepository;
import eu.cloudnetservice.driver.module.ModuleURLClassLoader;
import eu.cloudnetservice.driver.module.ModuleWrapper;
import jakarta.inject.Singleton;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import lombok.NonNull;
import org.jetbrains.annotations.Nullable;

@Singleton
@Provides(value={ModuleProvider.class})
public class DefaultModuleProvider
implements ModuleProvider {
    public static final Path DEFAULT_LIB_DIR = Path.of(".libs", new String[0]);
    public static final Path DEFAULT_MODULE_DIR = Path.of("modules", new String[0]);
    protected static final Logger LOGGER = LogManager.logger(DefaultModuleProvider.class);
    protected static final ModuleDependencyLoader DEFAULT_DEP_LOADER = new DefaultModuleDependencyLoader(DEFAULT_LIB_DIR);
    private static final Element MODULE_CONFIGURATION_ELEMENT = Element.forType(ModuleConfiguration.class);
    private static final Element DATA_DIRECTORY_ELEMENT = Element.forType(Path.class).requireAnnotation((Annotation)Qualifiers.named((String)"dataDirectory"));
    protected final Collection<ModuleWrapper> modules = new CopyOnWriteArrayList<ModuleWrapper>();
    protected Path moduleDirectory;
    protected ModuleProviderHandler moduleProviderHandler;
    protected ModuleDependencyLoader moduleDependencyLoader;

    public DefaultModuleProvider() {
        this(DEFAULT_MODULE_DIR, DEFAULT_DEP_LOADER);
    }

    public DefaultModuleProvider(@NonNull Path moduleDirectory, @NonNull ModuleDependencyLoader moduleDependencyLoader) {
        if (moduleDirectory == null) {
            throw new NullPointerException("moduleDirectory is marked non-null but is null");
        }
        if (moduleDependencyLoader == null) {
            throw new NullPointerException("moduleDependencyLoader is marked non-null but is null");
        }
        this.moduleDirectory = moduleDirectory;
        this.moduleDependencyLoader = moduleDependencyLoader;
    }

    @Override
    @NonNull
    public Path moduleDirectoryPath() {
        return this.moduleDirectory;
    }

    @Override
    public void moduleDirectoryPath(@NonNull Path moduleDirectory) {
        if (moduleDirectory == null) {
            throw new NullPointerException("moduleDirectory is marked non-null but is null");
        }
        this.moduleDirectory = moduleDirectory;
    }

    @Override
    @Nullable
    public ModuleProviderHandler moduleProviderHandler() {
        return this.moduleProviderHandler;
    }

    @Override
    public void moduleProviderHandler(@Nullable ModuleProviderHandler moduleProviderHandler) {
        this.moduleProviderHandler = moduleProviderHandler;
    }

    @Override
    @NonNull
    public ModuleDependencyLoader moduleDependencyLoader() {
        return this.moduleDependencyLoader;
    }

    @Override
    public void moduleDependencyLoader(@NonNull ModuleDependencyLoader moduleDependencyLoader) {
        if (moduleDependencyLoader == null) {
            throw new NullPointerException("moduleDependencyLoader is marked non-null but is null");
        }
        this.moduleDependencyLoader = moduleDependencyLoader;
    }

    @Override
    @NonNull
    public Collection<ModuleWrapper> modules() {
        return Collections.unmodifiableCollection(this.modules);
    }

    @Override
    @NonNull
    public Collection<ModuleWrapper> modules(@NonNull String group) {
        if (group == null) {
            throw new NullPointerException("group is marked non-null but is null");
        }
        return this.modules.stream().filter(module -> module.moduleConfiguration().group().equals(group)).toList();
    }

    @Override
    @Nullable
    public ModuleWrapper module(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        return this.modules.stream().filter(module -> module.moduleConfiguration().name().equals(name)).findFirst().orElse(null);
    }

    @Override
    @Nullable
    public ModuleWrapper loadModule(@NonNull URL url) {
        if (url == null) {
            throw new NullPointerException("url is marked non-null but is null");
        }
        try {
            if (this.findModuleBySource(url).isPresent()) {
                return null;
            }
            ModuleConfiguration moduleConfiguration = this.findModuleConfiguration(url).orElse(null);
            if (moduleConfiguration == null) {
                throw new ModuleConfigurationNotFoundException(url);
            }
            if (!moduleConfiguration.canRunOn(JavaVersion.runtimeVersion())) {
                LOGGER.warning(String.format("Unable to load module %s:%s because it only supports Java %d+", moduleConfiguration.group(), moduleConfiguration.name(), moduleConfiguration.minJavaVersionId()));
                return null;
            }
            Path dataDirectory = moduleConfiguration.dataFolder(this.moduleDirectory);
            InjectionLayer<Injector> externalLayer = InjectionLayer.ext();
            InjectionLayer<SpecifiedInjector> moduleLayer = InjectionLayer.specifiedChild(externalLayer, "module", (layer, injector) -> {
                injector.installSpecified(BindingBuilder.create().bind(DATA_DIRECTORY_ELEMENT).toInstance((Object)dataDirectory));
                injector.installSpecified(BindingBuilder.create().bind(MODULE_CONFIGURATION_ELEMENT).toInstance((Object)moduleConfiguration));
            });
            Map<String, String> repositories = this.collectModuleProvidedRepositories(moduleConfiguration);
            Tuple2<Set<URL>, Set<ModuleDependency>> dependencies = this.loadDependencies(repositories, moduleConfiguration);
            ModuleURLClassLoader loader = new ModuleURLClassLoader(url, (Set)dependencies.first(), moduleLayer);
            loader.registerGlobally();
            Class<?> mainModuleClass = loader.loadClass(moduleConfiguration.main());
            if (!Module.class.isAssignableFrom(mainModuleClass)) {
                throw new AssertionError((Object)String.format("Module main class %s is not assignable from %s", mainModuleClass.getCanonicalName(), Module.class.getCanonicalName()));
            }
            Module moduleInstance = (Module)moduleLayer.instance(mainModuleClass);
            DefaultModuleWrapper moduleWrapper = new DefaultModuleWrapper(url, moduleInstance, dataDirectory, this, loader, (Set)dependencies.second(), moduleConfiguration, moduleLayer);
            moduleInstance.init(loader, moduleWrapper, moduleConfiguration);
            this.modules.add(moduleWrapper);
            return moduleWrapper.loadModule();
        }
        catch (IOException | URISyntaxException exception) {
            throw new AssertionError("Exception reading module information of " + url, exception);
        }
        catch (ReflectiveOperationException exception) {
            throw new AssertionError("Exception creating module instance", exception);
        }
    }

    @Override
    @Nullable
    public ModuleWrapper loadModule(@NonNull Path path) {
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        try {
            return this.loadModule(path.toUri().toURL());
        }
        catch (MalformedURLException exception) {
            LOGGER.severe("Unable to resolve url of module path", (Throwable)exception, new Object[0]);
            return null;
        }
    }

    @Override
    @NonNull
    public ModuleProvider loadAll() {
        FileUtil.walkFileTree((Path)this.moduleDirectory, ($, current) -> this.loadModule((Path)current), (boolean)false, (String)"*.{jar,war}");
        return this;
    }

    @Override
    @NonNull
    public ModuleProvider startAll() {
        for (ModuleWrapper module : this.modules) {
            module.startModule();
        }
        return this;
    }

    @Override
    @NonNull
    public ModuleProvider reloadAll() {
        for (ModuleWrapper module : this.modules) {
            module.reloadModule();
        }
        return this;
    }

    @Override
    @NonNull
    public ModuleProvider stopAll() {
        for (ModuleWrapper module : this.modules) {
            module.stopModule();
        }
        return this;
    }

    @Override
    @NonNull
    public ModuleProvider unloadAll() {
        for (ModuleWrapper module : this.modules) {
            module.unloadModule();
        }
        return this;
    }

    @Override
    public boolean notifyPreModuleLifecycleChange(@NonNull ModuleWrapper wrapper, @NonNull ModuleLifeCycle lifeCycle) {
        ModuleProviderHandler handler;
        if (wrapper == null) {
            throw new NullPointerException("wrapper is marked non-null but is null");
        }
        if (lifeCycle == null) {
            throw new NullPointerException("lifeCycle is marked non-null but is null");
        }
        if (lifeCycle == ModuleLifeCycle.UNLOADED) {
            this.modules.remove(wrapper);
        }
        if ((handler = this.moduleProviderHandler) != null) {
            switch (lifeCycle) {
                case LOADED: {
                    return handler.handlePreModuleLoad(wrapper);
                }
                case STARTED: {
                    return handler.handlePreModuleStart(wrapper);
                }
                case RELOADING: {
                    return handler.handlePreModuleReload(wrapper);
                }
                case STOPPED: {
                    return handler.handlePreModuleStop(wrapper);
                }
                case UNLOADED: {
                    handler.handlePreModuleUnload(wrapper);
                    break;
                }
            }
        }
        return true;
    }

    @Override
    public void notifyPostModuleLifecycleChange(@NonNull ModuleWrapper wrapper, @NonNull ModuleLifeCycle lifeCycle) {
        if (wrapper == null) {
            throw new NullPointerException("wrapper is marked non-null but is null");
        }
        if (lifeCycle == null) {
            throw new NullPointerException("lifeCycle is marked non-null but is null");
        }
        ModuleProviderHandler handler = this.moduleProviderHandler;
        if (handler != null) {
            switch (lifeCycle) {
                case LOADED: {
                    handler.handlePostModuleLoad(wrapper);
                    break;
                }
                case STARTED: {
                    handler.handlePostModuleStart(wrapper);
                    break;
                }
                case RELOADING: {
                    handler.handlePostModuleReload(wrapper);
                    break;
                }
                case STOPPED: {
                    handler.handlePostModuleStop(wrapper);
                    break;
                }
                case UNLOADED: {
                    handler.handlePostModuleUnload(wrapper);
                    break;
                }
            }
        }
    }

    @NonNull
    protected Optional<ModuleConfiguration> findModuleConfiguration(@NonNull URL moduleFile) throws IOException {
        if (moduleFile == null) {
            throw new NullPointerException("moduleFile is marked non-null but is null");
        }
        try (BufferedInputStream buffered = new BufferedInputStream(moduleFile.openStream());
             JarInputStream inputStream = new JarInputStream(buffered);){
            JarEntry entry;
            while ((entry = inputStream.getNextJarEntry()) != null) {
                if (!entry.getName().equals("module.json")) continue;
                Document.Mutable serializedModuleConfiguration = DocumentFactory.json().parse(inputStream);
                Optional<ModuleConfiguration> optional = Optional.of(serializedModuleConfiguration.toInstanceOf(ModuleConfiguration.class));
                return optional;
            }
        }
        return Optional.empty();
    }

    @NonNull
    protected Optional<ModuleWrapper> findModuleBySource(@NonNull URL fileSource) throws URISyntaxException {
        if (fileSource == null) {
            throw new NullPointerException("fileSource is marked non-null but is null");
        }
        URI fileSourceUri = fileSource.toURI();
        for (ModuleWrapper module : this.modules) {
            if (!module.uri().equals(fileSourceUri)) continue;
            return Optional.of(module);
        }
        return Optional.empty();
    }

    @NonNull
    protected Map<String, String> collectModuleProvidedRepositories(@NonNull ModuleConfiguration configuration) {
        if (configuration == null) {
            throw new NullPointerException("configuration is marked non-null but is null");
        }
        HashMap<String, String> repositories = new HashMap<String, String>();
        if (configuration.repositories() != null) {
            for (ModuleRepository repo : configuration.repositories()) {
                if (repo == null) continue;
                repo.assertComplete();
                repositories.putIfAbsent(repo.name(), (String)(repo.url().endsWith("/") ? repo.url() : repo.url() + "/"));
            }
        }
        return repositories;
    }

    @NonNull
    protected Tuple2<Set<URL>, Set<ModuleDependency>> loadDependencies(@NonNull Map<String, String> repos, @NonNull ModuleConfiguration configuration) {
        if (repos == null) {
            throw new NullPointerException("repos is marked non-null but is null");
        }
        if (configuration == null) {
            throw new NullPointerException("configuration is marked non-null but is null");
        }
        HashSet<URL> loadedDependencies = new HashSet<URL>();
        HashSet<ModuleDependency> pendingModuleDependencies = new HashSet<ModuleDependency>();
        if (configuration.dependencies() != null) {
            ModuleProviderHandler handler = this.moduleProviderHandler;
            for (ModuleDependency dependency : configuration.dependencies()) {
                if (dependency == null) continue;
                dependency.assertDefaultPropertiesSet();
                if (dependency.url() != null) {
                    loadedDependencies.add(this.doLoadDependency(dependency, configuration, handler, () -> this.moduleDependencyLoader.loadModuleDependencyByUrl(configuration, dependency)));
                    continue;
                }
                if (dependency.repo() != null) {
                    String repoUrl = (String)Preconditions.checkNotNull((Object)repos.get(dependency.repo()), (String)"Dependency %s declared unknown repository %s as it's source", (Object)dependency.toString(), (Object)dependency.repo());
                    loadedDependencies.add(this.doLoadDependency(dependency, configuration, handler, () -> this.moduleDependencyLoader.loadModuleDependencyByRepository(configuration, dependency, repoUrl)));
                    continue;
                }
                pendingModuleDependencies.add(dependency);
            }
        }
        return new Tuple2(loadedDependencies, pendingModuleDependencies);
    }

    @NonNull
    protected URL doLoadDependency(@NonNull ModuleDependency dependency, @NonNull ModuleConfiguration configuration, @Nullable ModuleProviderHandler handler, @NonNull Callable<URL> loader) {
        if (dependency == null) {
            throw new NullPointerException("dependency is marked non-null but is null");
        }
        if (configuration == null) {
            throw new NullPointerException("configuration is marked non-null but is null");
        }
        if (loader == null) {
            throw new NullPointerException("loader is marked non-null but is null");
        }
        if (handler != null) {
            handler.handlePreInstallDependency(configuration, dependency);
        }
        try {
            URL loadResult = loader.call();
            if (handler != null) {
                handler.handlePostInstallDependency(configuration, dependency);
            }
            return loadResult;
        }
        catch (Exception exception) {
            throw new AssertionError(String.format("Failed to load module dependency %s", dependency), exception);
        }
    }
}

