/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.driver.module;

import eu.cloudnetservice.common.io.FileUtil;
import eu.cloudnetservice.driver.module.ModuleConfiguration;
import eu.cloudnetservice.driver.module.ModuleDependency;
import eu.cloudnetservice.driver.module.ModuleDependencyLoader;
import eu.cloudnetservice.ext.updater.util.ChecksumUtil;
import java.net.URL;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Objects;
import kong.unirest.core.Unirest;
import lombok.NonNull;

public class DefaultModuleDependencyLoader
implements ModuleDependencyLoader {
    protected static final String FILE_NAME_FORMAT = "%s-%s.jar";
    protected static final String REMOTE_DEPENDENCY_URL_FORMAT = "%s%s/%s/%s/%s-%s.jar";
    protected final Path baseDirectory;

    public DefaultModuleDependencyLoader(@NonNull Path baseDirectory) {
        if (baseDirectory == null) {
            throw new NullPointerException("baseDirectory is marked non-null but is null");
        }
        this.baseDirectory = baseDirectory;
    }

    @Override
    @NonNull
    public URL loadModuleDependencyByUrl(@NonNull ModuleConfiguration configuration, @NonNull ModuleDependency dependency) throws Exception {
        if (configuration == null) {
            throw new NullPointerException("configuration is marked non-null but is null");
        }
        if (dependency == null) {
            throw new NullPointerException("dependency is marked non-null but is null");
        }
        String url = Objects.requireNonNull(dependency.url(), "Dependency url must be given");
        return this.loadDependency(dependency, new URL(url));
    }

    @Override
    @NonNull
    public URL loadModuleDependencyByRepository(@NonNull ModuleConfiguration configuration, @NonNull ModuleDependency dependency, @NonNull String repositoryUrl) throws Exception {
        if (configuration == null) {
            throw new NullPointerException("configuration is marked non-null but is null");
        }
        if (dependency == null) {
            throw new NullPointerException("dependency is marked non-null but is null");
        }
        if (repositoryUrl == null) {
            throw new NullPointerException("repositoryUrl is marked non-null but is null");
        }
        return this.loadDependency(dependency, new URL(String.format(REMOTE_DEPENDENCY_URL_FORMAT, repositoryUrl, dependency.group().replace('.', '/'), dependency.name(), dependency.version(), dependency.name(), dependency.version())));
    }

    @NonNull
    protected URL loadDependency(@NonNull ModuleDependency dependency, @NonNull URL url) throws Exception {
        String checksum;
        if (dependency == null) {
            throw new NullPointerException("dependency is marked non-null but is null");
        }
        if (url == null) {
            throw new NullPointerException("url is marked non-null but is null");
        }
        Path destFile = FileUtil.resolve((Path)this.baseDirectory, (String[])dependency.group().split("\\.")).resolve(dependency.name()).resolve(dependency.version()).resolve(String.format(FILE_NAME_FORMAT, dependency.name(), dependency.version()));
        FileUtil.ensureChild((Path)this.baseDirectory, (Path)destFile);
        if (dependency.checksum() != null && Files.exists(destFile, new LinkOption[0]) && !(checksum = ChecksumUtil.fileShaSum((Path)destFile)).equals(dependency.checksum())) {
            FileUtil.delete((Path)destFile);
        }
        if (Files.notExists(destFile, new LinkOption[0])) {
            Files.createDirectories(destFile.getParent(), new FileAttribute[0]);
            Unirest.get((String)url.toExternalForm()).asFile(destFile.toString(), new CopyOption[0]);
            if (dependency.checksum() != null && !(checksum = ChecksumUtil.fileShaSum((Path)destFile)).equals(dependency.checksum())) {
                FileUtil.delete((Path)destFile);
                throw new IllegalStateException("Unable to verify checksum of downloaded dependency " + dependency);
            }
        }
        return destFile.toUri().toURL();
    }

    @NonNull
    public Path baseDirectory() {
        return this.baseDirectory;
    }
}

