/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.driver.event;

import dev.derklaro.aerogel.auto.Provides;
import eu.cloudnetservice.driver.event.DefaultRegisteredEventListener;
import eu.cloudnetservice.driver.event.Event;
import eu.cloudnetservice.driver.event.EventListener;
import eu.cloudnetservice.driver.event.EventManager;
import eu.cloudnetservice.driver.event.RegisteredEventListener;
import eu.cloudnetservice.driver.inject.InjectionLayer;
import jakarta.inject.Singleton;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Predicate;
import lombok.NonNull;

@Singleton
@Provides(value={EventManager.class})
public class DefaultEventManager
implements EventManager {
    protected final Lock bakeLock = new ReentrantLock(true);
    protected final Map<Class<?>, List<RegisteredEventListener>> listeners = new HashMap();

    @Override
    @NonNull
    public EventManager unregisterListeners(@NonNull ClassLoader classLoader) {
        if (classLoader == null) {
            throw new NullPointerException("classLoader is marked non-null but is null");
        }
        this.safeRemove(value -> value.instance().getClass().getClassLoader().equals(classLoader));
        return this;
    }

    @Override
    @NonNull
    public EventManager unregisterListener(Object ... listeners) {
        if (listeners == null) {
            throw new NullPointerException("listeners is marked non-null but is null");
        }
        List<Object> listenerList = Arrays.asList(listeners);
        this.safeRemove(value -> listenerList.contains(value.instance()));
        return this;
    }

    @Override
    @NonNull
    public <T extends Event> T callEvent(@NonNull String channel, @NonNull T event) {
        if (channel == null) {
            throw new NullPointerException("channel is marked non-null but is null");
        }
        if (event == null) {
            throw new NullPointerException("event is marked non-null but is null");
        }
        List<RegisteredEventListener> listeners = this.listeners.get(event.getClass());
        if (listeners != null && !listeners.isEmpty()) {
            if (listeners.size() == 1) {
                RegisteredEventListener listener = listeners.get(0);
                if (listener.channel().equals(channel)) {
                    listener.fireEvent(event);
                }
            } else {
                for (RegisteredEventListener listener : listeners) {
                    if (!listener.channel().equals(channel)) continue;
                    listener.fireEvent(event);
                }
            }
        }
        return event;
    }

    @Override
    @NonNull
    public EventManager registerListener(@NonNull Class<?> listenerClass) {
        if (listenerClass == null) {
            throw new NullPointerException("listenerClass is marked non-null but is null");
        }
        InjectionLayer<?> injectionLayer = InjectionLayer.findLayerOf(listenerClass);
        return this.registerListener(injectionLayer, injectionLayer.instance(listenerClass));
    }

    @Override
    @NonNull
    public EventManager registerListener(@NonNull Object listener) {
        if (listener == null) {
            throw new NullPointerException("listener is marked non-null but is null");
        }
        InjectionLayer<?> injectionLayer = InjectionLayer.findLayerOf(listener);
        return this.registerListener(injectionLayer, listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    protected EventManager registerListener(@NonNull InjectionLayer<?> layer, @NonNull Object listener) {
        if (layer == null) {
            throw new NullPointerException("layer is marked non-null but is null");
        }
        if (listener == null) {
            throw new NullPointerException("listener is marked non-null but is null");
        }
        for (Method method : listener.getClass().getDeclaredMethods()) {
            EventListener annotation = method.getAnnotation(EventListener.class);
            if (annotation == null || Modifier.isStatic(method.getModifiers()) || method.getParameterCount() < 1) continue;
            Class<?> eventClass = method.getParameterTypes()[0];
            if (!Event.class.isAssignableFrom(eventClass)) {
                throw new IllegalArgumentException(String.format("Parameter type %s (index 0) of listener method %s in %s is not a subclass of Event", eventClass.getName(), method.getName(), listener.getClass().getName()));
            }
            DefaultRegisteredEventListener eventListener = new DefaultRegisteredEventListener(listener, method, annotation, layer);
            this.bakeLock.lock();
            try {
                List listeners = this.listeners.computeIfAbsent(eventClass, $ -> new CopyOnWriteArrayList());
                listeners.add(eventListener);
                Collections.sort(listeners);
            }
            finally {
                this.bakeLock.unlock();
            }
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void safeRemove(@NonNull Predicate<RegisteredEventListener> predicate) {
        if (predicate == null) {
            throw new NullPointerException("predicate is marked non-null but is null");
        }
        this.bakeLock.lock();
        try {
            Iterator<List<RegisteredEventListener>> iterator = this.listeners.values().iterator();
            while (iterator.hasNext()) {
                List<RegisteredEventListener> entry = iterator.next();
                entry.removeIf(predicate);
                if (!entry.isEmpty()) continue;
                iterator.remove();
            }
        }
        finally {
            this.bakeLock.unlock();
        }
    }
}

